/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.ArrayList;
import java.util.Locale;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"fold"})
@Help(key="aggregation-fold")
public class FoldAggregation
implements Aggregation<Object> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Object> expr;
    private final Object initialValue;
    private final Scalar<Object> fn;
    private final Type<Object> type;
    private final Scalar<Object> merger;
    private final Scalar<Object> initialExpr;
    private final Scalar<Object> mergerExpr;
    private final String repr;

    public FoldAggregation(ArgQueue queue) throws PipeException {
        this(queue, "fold(%s)");
    }

    public FoldAggregation(ArgQueue queue, String name) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        this.initialExpr = (Scalar)queue.constant((Type)Type.OBJECT).getSafe();
        this.initialValue = this.initialExpr != null ? this.initialExpr.eval(null, null) : null;
        this.type = this.initialExpr != null ? this.initialExpr.type() : this.expr.type();
        this.fn = (Scalar)queue.withContext(queue.context().newSource(queue.metadata().withType((Type)this.makeRow("acc", this.type, "it", this.expr.type())))).scalar(this.type).get();
        this.mergerExpr = (Scalar)queue.withContext(queue.context().newSource(queue.metadata().withType((Type)this.makeRow("a", this.type, "b", this.type)))).scalar(this.type).getSafe();
        Scalar<Object> scalar = this.merger = this.mergerExpr == null && this.type.equals((Object)this.expr.type()) ? this.fn : this.mergerExpr;
        if (this.merger == null) {
            queue.ensureSafe();
        }
        this.repr = this.toString(name);
    }

    private RowType makeRow(String aName, Type aType, String bName, Type bType) {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo(aName, aType), new FieldInfo(bName, bType)})));
    }

    public Type type() {
        return this.type;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return this.repr;
    }

    private String toString(String format) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.expr.toString());
        if (this.initialExpr != null) {
            args.add(this.initialExpr.toString());
        }
        args.add(this.fn.toString());
        if (this.mergerExpr != null) {
            args.add(this.mergerExpr.toString());
        }
        return String.format((Locale)null, format, Iterables.join((String)", ", args));
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyMerger();
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public long weight() {
        return 48L;
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree myTree = (MyTree)tree;
        if (myTree.initialized) {
            return myTree.value;
        }
        return this.initialValue;
    }

    public boolean accept(Object eval) {
        return true;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        PropertyVisitor result = this.fn.visit(parent, visitor.newScope());
        if (this.merger != null) {
            this.merger.visit(null, result);
        }
        return result;
    }

    public void validate(ValidationContext context) throws PipeException {
        context = context.defer(new Expression[]{this.expr});
        if (this.merger == null) {
            context.validateAs((Expression)this).ensureNoWindow();
        }
    }

    private class MyMerger
    extends InsertMerger.Base<MyTree> {
        private long initialized = 0L;
        private Object value = null;

        private MyMerger() {
        }

        public void pushQ(MyTree tree) {
            if (!tree.initialized) {
                return;
            }
            if (FoldAggregation.this.merger != null) {
                this.value = this.initialized++ > 0L ? FoldAggregation.this.merger.eval(null, (Object)new ArrayRow(new Object[]{this.value, tree.value})) : tree.value;
            } else {
                this.value = tree.value;
                ++this.initialized;
            }
        }

        public void clear() {
            this.value = null;
            this.initialized = 0L;
        }

        public MyTree get() {
            return new MyTree(this.initialized > 0L, this.initialized > 0L ? this.value : FoldAggregation.this.initialValue);
        }
    }

    private class MyState
    implements State {
        private volatile boolean initialized = false;
        private Object value;

        public MyState() {
            this.initializeVariables();
        }

        private void initializeVariables() {
            if (FoldAggregation.this.initialExpr != null) {
                this.value = FoldAggregation.this.initialValue;
                this.initialized = true;
            } else {
                this.value = null;
                this.initialized = false;
            }
        }

        public void yield(Scope parent, Object obj) {
            Object o = FoldAggregation.this.expr.eval(parent, obj);
            if (!FoldAggregation.this.accept(o)) {
                return;
            }
            if (!this.initialized) {
                this.value = o;
                this.initialized = true;
            } else {
                this.value = FoldAggregation.this.fn.eval(new Scope(parent, obj), (Object)new ArrayRow(new Object[]{this.value, o}));
            }
        }

        public Tree flip() {
            MyTree result = new MyTree(this.initialized, this.value);
            this.initializeVariables();
            return result;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final boolean initialized;
        private final Object value;

        private MyTree(boolean initialized, Object value) {
            this.initialized = initialized;
            this.value = value;
        }
    }
}

