/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"if"})
@Help(key="aggregation-if")
public class IfAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final Aggregation<T> aggr;
    private final Scalar<Boolean> condition;

    public IfAggregation(ArgQueue queue) throws PipeException {
        this.aggr = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
        this.condition = (Scalar)queue.scalar((Type)Type.BOOLEAN).get();
    }

    public State newState(int flips) {
        return new MyState(this.aggr.newState(flips));
    }

    public Type<T> type() {
        return this.aggr.type();
    }

    public String toString() {
        return "if(" + this.aggr + ", " + this.condition + ")";
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return this.aggr.ttl();
    }

    public long weight() {
        return 8L + this.aggr.weight();
    }

    public FullMerger newMerger() {
        return this.aggr.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.aggr.newInsertMerger();
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (T)this.aggr.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.condition.visit(parent, visitor);
        return this.aggr.visit(parent, visitor);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.aggr, this.condition});
    }

    private class MyState
    implements State {
        private final State inner;

        public MyState(State inner) {
            this.inner = inner;
        }

        public void yield(Scope parent, Object obj) {
            if (Boolean.TRUE.equals(IfAggregation.this.condition.eval(parent, obj))) {
                this.inner.yield(parent, obj);
            }
        }

        public Tree flip() {
            return this.inner.flip();
        }
    }
}

