/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.Locale;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.ComparableAtom;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SortField;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.SortFieldImpl;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

public abstract class OrderAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final SortField[] comp;
    private final Scalar<T> expr;
    private final String desc;
    private final boolean reverse;
    private final int ordering;

    public OrderAggregation(Scalar<? extends Comparable> expr, boolean reverse, String desc) throws PipeException {
        this((Scalar)expr, (Evaluable<Comparable>)expr, reverse, desc);
    }

    public OrderAggregation(Scalar expr, Evaluable<? extends Comparable> comp, boolean reverse, String desc) throws PipeException {
        this(expr, new SortField[]{new SortFieldImpl(comp, false)}, reverse, desc);
    }

    public OrderAggregation(Scalar expr, SortField[] comp, boolean reverse, String desc) throws PipeException {
        PipeException.check((comp.length > 0 ? 1 : 0) != 0, (Object)"Must define sort fields.");
        this.reverse = reverse;
        this.expr = expr;
        this.comp = comp;
        this.desc = String.format((Locale)null, desc, expr, Iterables.join((String)", ", (Object[])comp));
        this.ordering = reverse ? -1 : 1;
    }

    public Type<T> type() {
        return this.expr.type();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public State newState(int flips) {
        return new MyState();
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public String toString() {
        return this.desc;
    }

    public long weight() {
        return 72L;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        ComparableAtom atom = ((MyTree)tree).atom;
        if (atom == null) {
            return null;
        }
        return (T)atom.value();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
        for (SortField field : this.comp) {
            field.validate(context);
        }
    }

    public boolean accept(T eval) {
        return true;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (SortField field : this.comp) {
            field.visit(parent, visitor);
        }
        return this.expr.visit(parent, visitor);
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MyTree<T>> {
        private ComparableAtom atom = null;

        private MyInsertMerger() {
        }

        public void clear() {
            this.atom = null;
        }

        public void pushQ(MyTree<T> tree) {
            if (tree == null || tree.atom == null) {
                return;
            }
            if (this.atom == null || OrderAggregation.this.ordering * tree.atom.compareTo(this.atom) < (OrderAggregation.this.reverse ? 1 : 0)) {
                this.atom = tree.atom;
            }
        }

        public MyTree<T> get() {
            return new MyTree(this.atom);
        }
    }

    private class MyState
    implements State {
        private ComparableAtom atom = null;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Object eval = OrderAggregation.this.expr.eval(parent, obj);
            if (!OrderAggregation.this.accept(eval)) {
                return;
            }
            ComparableAtom maybeAtom = ComparableAtom.create((Object)eval, (Scope)parent, (Object)obj, (Evaluable[])OrderAggregation.this.comp);
            if (this.atom == null || OrderAggregation.this.ordering * maybeAtom.compareTo(this.atom) < (OrderAggregation.this.reverse ? 1 : 0)) {
                this.atom = maybeAtom;
            }
        }

        public Tree flip() {
            MyTree mergeable = new MyTree(this.atom);
            this.atom = null;
            return mergeable;
        }
    }

    private static class MyTree<T>
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final ComparableAtom atom;

        private MyTree(ComparableAtom atom) {
            this.atom = atom;
        }
    }
}

