/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"overall"})
@Help(key="aggregation-overall")
public class OverallAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final Aggregation<T> expr;

    public OverallAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
    }

    public Type<T> type() {
        return this.expr.type();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return "overall(" + this.expr + ")";
    }

    public State newState(int flips) {
        return new MyState(this.expr.newState(flips), this.expr.newMerger());
    }

    public FullMerger newMerger() {
        return this.expr.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.expr.newInsertMerger();
    }

    public long weight() {
        return 2L * this.expr.weight() + 24L;
    }

    public long ttl() {
        return Long.MAX_VALUE;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (T)this.expr.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expr.visit(parent, visitor);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr}).validateAs((Expression)this).ensureNoWindow();
    }

    private class MyState
    implements State {
        private final State state;
        private final FullMerger merger;
        private volatile Tree tree = null;

        public MyState(State state, FullMerger merger) {
            this.state = state;
            this.merger = merger;
        }

        public void yield(Scope parent, Object obj) {
            this.state.yield(parent, obj);
        }

        public Tree flip() {
            if (this.tree != null) {
                this.merger.push(this.tree);
            }
            this.merger.push(this.state.flip());
            this.tree = this.merger.get();
            this.merger.clear();
            return this.tree;
        }
    }
}

