/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.Deque;
import java.util.LinkedList;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"overlast"})
@Help(key="aggregation-overlast")
public class OverlastAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final Aggregation<T> expr;
    private final int last;

    public OverlastAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
        this.last = ((Double)queue.constantValue((Type)Type.NUMBER).get()).intValue();
        PipeException.check((this.last > 0 ? 1 : 0) != 0, (Object)"last must be positive");
    }

    public Type<T> type() {
        return this.expr.type();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return "overlast(" + this.expr + ", " + this.last + ")";
    }

    public State newState(int flips) {
        return new MyState(this.expr.newState(flips), this.expr.newMerger());
    }

    public FullMerger newMerger() {
        return this.expr.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.expr.newInsertMerger();
    }

    public int last() {
        return this.last;
    }

    public long ttl() {
        return (long)this.last + this.expr.ttl() - 1L;
    }

    public long weight() {
        return (long)this.last * this.expr.weight() + (long)(this.last * 8) + 24L;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (T)this.expr.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expr.visit(parent, visitor);
    }

    public void validate(ValidationContext context) throws PipeException {
        new ValidationContext(true).defer(new Expression[]{this.expr});
        context.validateAs((Expression)this).ensureNoWindow();
    }

    private class MyState
    implements State {
        private final State state;
        private final Deque<Tree> queue = new LinkedList<Tree>();
        private final FullMerger merger;

        public MyState(State state, FullMerger merger) {
            this.state = state;
            this.merger = merger;
        }

        public void yield(Scope parent, Object obj) {
            this.state.yield(parent, obj);
        }

        public Tree flip() {
            Tree tree = this.state.flip();
            this.queue.add(tree);
            this.merger.push(tree);
            if (this.queue.size() > OverlastAggregation.this.last) {
                this.queue.remove();
                this.merger.pop();
            }
            return this.merger.get();
        }
    }
}

