/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.ForwardingExpression;
import net.intelie.pipes.Help;
import net.intelie.pipes.MacroModule;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Type;

@Export(value={"pcount"})
@Help(key="aggregation-pcount")
public class PCountAggregation
extends ForwardingExpression<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Boolean> expr;
    private final Aggregation<Double> impl;

    public PCountAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.BOOLEAN).get();
        this.impl = (Aggregation)queue.compiler().expression().withModule((Module)new MacroModule(new Object[]{this.expr})).compileToQueue(new String[]{"avg(@@0#)"}).aggregation((Type)Type.NUMBER).get();
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        return this.normalize((Double)super.eval(parent, tree, bounds));
    }

    private Double normalize(Double x) {
        if (x == null) {
            return null;
        }
        return Math.min(1.0, Math.max(0.0, x));
    }

    public Expression<Double> delegate() {
        return this.impl;
    }

    public String toString() {
        return "pcount(" + this.expr + ")";
    }
}

