/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={".peek"})
@Help(key="operator-peek")
public class PeekAggregation
implements Aggregation {
    private static final long serialVersionUID = 1L;
    private final Scalar scalar;
    private final Aggregation aggregation;

    public PeekAggregation(ArgQueue queue) throws PipeException {
        this.scalar = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        this.aggregation = (Aggregation)queue.withContext(queue.context().newChildSource(queue.metadata().withType(this.scalar.type()))).aggregation((Type)Type.OBJECT).get();
        PipeException.check((!Level.SCALAR.accepts((Object)this.aggregation) ? 1 : 0) != 0, (String)"This implementation does not accept a scalar as argument: %s", (Object[])new Object[]{this.aggregation});
    }

    public State newState(int flips) {
        return new MyState(this.aggregation.newState(flips));
    }

    public FullMerger newMerger() {
        return this.aggregation.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.aggregation.newInsertMerger();
    }

    public Type type() {
        return this.aggregation.type();
    }

    public Level level() {
        return this.aggregation.level();
    }

    public long ttl() {
        return Math.max(this.scalar.ttl(), this.aggregation.ttl());
    }

    public long weight() {
        return this.aggregation.weight();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.aggregation, this.scalar});
    }

    public String toString() {
        return "(" + this.scalar + "->(" + this.aggregation + "))";
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        return this.aggregation.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.scalar.visit(parent, visitor);
        return PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, (PropertySink)this.aggregation);
    }

    private class MyState
    implements State {
        private final State state;

        public MyState(State state) {
            this.state = state;
        }

        public void yield(Scope parent, Object obj) {
            Object value = PeekAggregation.this.scalar.eval(parent, obj);
            this.state.yield(new Scope(parent, obj), value);
        }

        public Tree flip() {
            return this.state.flip();
        }
    }
}

