/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.ArrayList;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.AnyExpr;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"pfold"})
@Help(key="aggregation-pfold")
public class PersistentFoldAggregation
implements Aggregation<Object> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Object> expr;
    private final Object initialValue;
    private final Scalar<Object> fn;
    private final Type<Object> type;
    private final Scalar<Object> initialExpr;

    public PersistentFoldAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        this.initialExpr = (Scalar)queue.constant((Type)Type.OBJECT).getSafe();
        this.initialValue = this.initialExpr != null ? this.initialExpr.eval(null, null) : null;
        this.type = this.initialExpr != null ? this.initialExpr.type() : this.expr.type();
        this.fn = (Scalar)queue.withContext(queue.context().newChildSource(queue.metadata().withType((Type)this.makeRow("acc", this.type, "it", this.expr.type())))).scalar(this.type).get();
        queue.ensureSafe();
    }

    private RowType makeRow(String aName, Type aType, String bName, Type bType) {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo(aName, aType), new FieldInfo(bName, bType)})));
    }

    public Type type() {
        return this.type;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.expr.toString());
        if (this.initialExpr != null) {
            args.add(this.initialExpr.toString());
        }
        args.add(this.fn.toString());
        return "pfold(" + Iterables.join((String)", ", args) + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new AnyExpr.AnyMerger();
    }

    public InsertMerger newInsertMerger() {
        return new AnyExpr.AnyMerger();
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public long weight() {
        return 48L;
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        return AnyExpr.evalTree((Tree)((AnyExpr.AnyTree)tree));
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        PropertyVisitor result = PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, this.fn);
        return result;
    }

    public void validate(ValidationContext context) throws PipeException {
        context = context.defer(new Expression[]{this.expr});
        context.validateAs((Expression)this).ensureNoWindow();
    }

    private class MyState
    implements State {
        private boolean initialized = false;
        private Object value;

        public MyState() {
            this.initializeVariables();
        }

        private void initializeVariables() {
            if (PersistentFoldAggregation.this.initialExpr != null) {
                this.value = PersistentFoldAggregation.this.initialValue;
                this.initialized = true;
            } else {
                this.value = null;
                this.initialized = false;
            }
        }

        public void yield(Scope parent, Object obj) {
            Object o = PersistentFoldAggregation.this.expr.eval(parent, obj);
            if (!this.initialized) {
                this.value = o;
                this.initialized = true;
            } else {
                this.value = PersistentFoldAggregation.this.fn.eval(new Scope(parent, obj), (Object)new ArrayRow(new Object[]{this.value, o}));
            }
        }

        public Tree flip() {
            return new AnyExpr.AnyTree(this.value);
        }
    }
}

