/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.ArrayDeque;
import java.util.Queue;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"prev"})
@Help(key="aggregation-prev")
public class PrevAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final Aggregation<T> expr;
    private final int last;

    public PrevAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
        this.last = ((Double)queue.constantValue((Type)Type.NUMBER).getOptional(new FallbackToConstant<Double>(1.0))).intValue();
        PipeException.check((this.last > 0 ? 1 : 0) != 0, (Object)"last must be positive");
    }

    public Type<T> type() {
        return this.expr.type();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public State newState(int flips) {
        return new MyState(flips, this.expr.newState(Math.max(flips - this.last, 0)));
    }

    public FullMerger newMerger() {
        return new MyFullMerger();
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public long ttl() {
        return (long)this.last + this.expr.ttl();
    }

    public long weight() {
        return (long)(this.last + 1) * this.expr.weight() + 16L;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree myTree = (MyTree)tree;
        if (!myTree.init) {
            return null;
        }
        return (T)this.expr.eval(parent, myTree.value, bounds);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public String toString() {
        if (this.last > 1) {
            return "prev(" + this.expr + ", " + this.last + ")";
        }
        return "prev(" + this.expr + ")";
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expr.visit(parent, visitor);
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MyTree<T>> {
        private final InsertMerger merger;
        private int size;

        private MyInsertMerger() {
            this.merger = PrevAggregation.this.expr.newInsertMerger();
            this.size = 0;
        }

        public void pushQ(MyTree<T> tree) {
            if (tree.value != null) {
                this.merger.push(tree.value);
                ++this.size;
            }
        }

        public void clear() {
            this.merger.clear();
            this.size = 0;
        }

        public MyTree<T> get() {
            if (this.size > 0) {
                return new MyTree(true, this.merger.get());
            }
            return new MyTree(false, null);
        }
    }

    private class MyFullMerger
    extends FullMerger.Base<MyTree<T>> {
        private final FullMerger merger;
        private int size;

        private MyFullMerger() {
            this.merger = PrevAggregation.this.expr.newMerger();
            this.size = 0;
        }

        public void pushQ(MyTree<T> tree) {
            if (tree.value != null) {
                this.merger.push(tree.value);
                ++this.size;
            }
        }

        public void pop() {
            this.merger.pop();
            --this.size;
        }

        public void clear() {
            this.merger.clear();
            this.size = 0;
        }

        public MyTree<T> get() {
            if (this.size > 0) {
                return new MyTree(true, this.merger.get());
            }
            return new MyTree(false, null);
        }
    }

    private class MyState
    implements State {
        private final State inner;
        private final Queue<Tree> queue;

        public MyState(int flips, State inner) {
            this.queue = new ArrayDeque<Tree>(PrevAggregation.this.last);
            this.inner = inner;
            this.compensateFlips(flips, inner);
        }

        private void compensateFlips(int flips, State inner) {
            for (int i = 0; i < Math.min(flips, PrevAggregation.this.last); ++i) {
                this.queue.add(inner.flip());
            }
        }

        public void yield(Scope parent, Object obj) {
            this.inner.yield(parent, obj);
        }

        public Tree flip() {
            Tree newValue = this.inner.flip();
            boolean init = false;
            Tree result = null;
            if (this.queue.size() == PrevAggregation.this.last) {
                init = true;
                result = this.queue.remove();
            }
            this.queue.add(newValue);
            return new MyTree(init, result);
        }
    }

    private static class MyTree<T>
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final boolean init;
        private final Tree value;

        private MyTree(boolean init, Tree value) {
            this.init = init;
            this.value = value;
        }
    }
}

