/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;

@Export(value={"regression"})
@Help(key="aggregation-regression")
public class RegressionAggregation
implements Aggregation<Row> {
    private static final long serialVersionUID = 1L;
    private final boolean hasX;
    private final Evaluable<Double> xExpr;
    private final Scalar<Double> yExpr;

    public RegressionAggregation(ArgQueue queue) throws PipeException {
        Scalar arg1 = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        Scalar arg2 = (Scalar)queue.scalar((Type)Type.NUMBER).getOptional();
        if (arg2 != null) {
            this.hasX = true;
            this.xExpr = arg1;
            this.yExpr = arg2;
        } else {
            this.hasX = false;
            this.xExpr = queue.context().timestamp();
            this.yExpr = arg1;
        }
    }

    private static double safe(double mean) {
        if (Double.isNaN(mean) || Double.isInfinite(mean)) {
            return 0.0;
        }
        return mean;
    }

    private static double safeRounded(double mean) {
        BigDecimal bd = new BigDecimal(RegressionAggregation.safe(mean));
        bd = bd.setScale(10, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public Type<Row> type() {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo("n", (Type)Type.NUMBER), new FieldInfo("slope", (Type)Type.NUMBER), new FieldInfo("intercept", (Type)Type.NUMBER), new FieldInfo("correlation", (Type)Type.NUMBER), new FieldInfo("covariance", (Type)Type.NUMBER), new FieldInfo("xmean", (Type)Type.NUMBER), new FieldInfo("xstdev", (Type)Type.NUMBER), new FieldInfo("ymean", (Type)Type.NUMBER), new FieldInfo("ystdev", (Type)Type.NUMBER)})));
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return "regression(" + (this.hasX ? this.xExpr + ", " : "") + this.yExpr + ")";
    }

    public void validate(ValidationContext context) throws PipeException {
        if (this.xExpr instanceof Expression) {
            context.defer(new Expression[]{(Expression)this.xExpr});
        }
        context.defer(new Expression[]{this.yExpr});
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 40L;
    }

    public Row eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree mtree = (MyTree)tree;
        return new ArrayRow(new Object[]{(double)mtree.n, RegressionAggregation.safeRounded(mtree.sXY / mtree.xM2), RegressionAggregation.safeRounded(mtree.yM1 - mtree.sXY / mtree.xM2 * mtree.xM1), RegressionAggregation.safeRounded(mtree.sXY / (Math.sqrt(mtree.xM2) * Math.sqrt(mtree.yM2))), RegressionAggregation.safeRounded(mtree.sXY / (double)mtree.n), RegressionAggregation.safeRounded(mtree.xM1), RegressionAggregation.safeRounded(Math.sqrt(mtree.xM2 / (double)(mtree.n - 1L))), RegressionAggregation.safeRounded(mtree.yM1), RegressionAggregation.safeRounded(Math.sqrt(mtree.yM2 / (double)(mtree.n - 1L)))});
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile long n;
        private volatile double sXY;
        private volatile double xM1;
        private volatile double xM2;
        private volatile double yM1;
        private volatile double yM2;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            long nn = this.n + tree.n;
            double xdelta = tree.xM1 - this.xM1;
            double xdelta2 = xdelta * xdelta;
            double nxM1 = ((double)this.n * this.xM1 + (double)tree.n * tree.xM1) / (double)nn;
            double nxM2 = this.xM2 + tree.xM2 + xdelta2 * (double)this.n * (double)tree.n / (double)nn;
            double ydelta = tree.yM1 - this.yM1;
            double ydelta2 = ydelta * ydelta;
            double nyM1 = ((double)this.n * this.yM1 + (double)tree.n * tree.yM1) / (double)nn;
            double nyM2 = this.yM2 + tree.yM2 + ydelta2 * (double)this.n * (double)tree.n / (double)nn;
            double nsXY = this.sXY + tree.sXY + (double)(this.n * tree.n) * xdelta * ydelta / (double)nn;
            this.n = nn;
            this.sXY = RegressionAggregation.safe(nsXY);
            this.xM1 = RegressionAggregation.safe(nxM1);
            this.xM2 = RegressionAggregation.safe(nxM2);
            this.yM1 = RegressionAggregation.safe(nyM1);
            this.yM2 = RegressionAggregation.safe(nyM2);
        }

        public void removeQ(MyTree tree) {
            this.addQ(new MyTree(-tree.n, -tree.sXY, tree.xM1, -tree.xM2, tree.yM1, -tree.yM2));
        }

        public void clear() {
            this.n = 0L;
            this.yM2 = 0.0;
            this.yM1 = 0.0;
            this.xM2 = 0.0;
            this.xM1 = 0.0;
            this.sXY = 0.0;
        }

        public MyTree get() {
            return new MyTree(this.n, this.sXY, this.xM1, this.xM2, this.yM1, this.yM2);
        }
    }

    private class MyState
    implements State {
        private volatile long n = 0L;
        private volatile double sXY = 0.0;
        private volatile double xM1 = 0.0;
        private volatile double xM2 = 0.0;
        private volatile double yM1 = 0.0;
        private volatile double yM2 = 0.0;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Double xx = (Double)RegressionAggregation.this.xExpr.eval(parent, obj);
            Double yy = (Double)RegressionAggregation.this.yExpr.eval(parent, obj);
            if (xx == null || yy == null) {
                return;
            }
            double x = xx;
            double y = yy;
            this.sXY += (this.xM1 - x) * (this.yM1 - y) * (double)this.n / ((double)this.n + 1.0);
            long n1 = this.n++;
            double xdelta = x - this.xM1;
            double xdelta_n = xdelta / (double)this.n;
            this.xM1 += xdelta_n;
            this.xM2 += xdelta * xdelta_n * (double)n1;
            double ydelta = y - this.yM1;
            double ydelta_n = ydelta / (double)this.n;
            this.yM1 += ydelta_n;
            this.yM2 += ydelta * ydelta_n * (double)n1;
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.n, this.sXY, this.xM1, this.xM2, this.yM1, this.yM2);
            this.n = 0L;
            this.yM2 = 0.0;
            this.yM1 = 0.0;
            this.xM2 = 0.0;
            this.xM1 = 0.0;
            this.sXY = 0.0;
            return tree;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final long n;
        private final double sXY;
        private final double xM1;
        private final double xM2;
        private final double yM1;
        private final double yM2;

        public MyTree(long n, double sXY, double xM1, double xM2, double yM1, double yM2) {
            this.n = n;
            this.sXY = sXY;
            this.xM1 = xM1;
            this.xM2 = xM2;
            this.yM1 = yM1;
            this.yM2 = yM2;
        }
    }
}

