/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.HoltWinters;

@Export(value={"smooth"})
@Help(key="aggregation-smooth")
public class SmoothAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Double alpha;
    private final Double beta;
    private final Scalar<Double> expr;
    private final String repr;

    public SmoothAggregation(ArgQueue queue) throws PipeException {
        queue.ensureSafe();
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        this.alpha = (Double)queue.constantValue((Type)Type.NUMBER).getOptional();
        this.beta = (Double)queue.constantValue((Type)Type.NUMBER).getOptional();
        this.repr = this.decideRepr((Expression)this.expr, this.alpha, this.beta);
        this.checkValue(this.alpha, "alpha");
        this.checkValue(this.beta, "beta");
    }

    private String decideRepr(Expression expr, Double alpha, Double beta) {
        String s = "smooth(" + expr;
        if (alpha != null) {
            s = s + ", " + Type.STRING.cast((Object)alpha);
            if (beta != null) {
                s = s + ", " + Type.STRING.cast((Object)beta);
            }
        }
        s = s + ")";
        return s;
    }

    private void checkValue(Double value, String name) throws PipeException {
        if (value != null && (value < 0.0 || value > 1.0)) {
            throw new PipeException("Invalid value for " + name + " (%s), must be between 0 and 1 (inclusive)", new Object[]{Type.STRING.cast((Object)value)});
        }
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return this.repr;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr}).validateAs((Expression)this).ensureNoWindow();
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 48L;
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (tree == null) {
            return null;
        }
        return ((MyTree)tree).value;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile MyTree last = null;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            this.last = tree;
        }

        public void removeQ(MyTree tree) {
            if (this.last == tree) {
                this.last = null;
            }
        }

        public void clear() {
            this.last = null;
        }

        public MyTree get() {
            return this.last;
        }
    }

    private class MyState
    implements State {
        private final HoltWinters state;

        private MyState() {
            this.state = new HoltWinters(SmoothAggregation.this.alpha != null ? SmoothAggregation.this.alpha : 0.5, SmoothAggregation.this.beta != null ? SmoothAggregation.this.beta : 0.5);
        }

        public void yield(Scope parent, Object obj) {
            Double value = (Double)SmoothAggregation.this.expr.eval(parent, obj);
            if (value != null) {
                this.state.offer(value);
            }
        }

        public Tree flip() {
            return new MyTree(this.state.value());
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final double value;

        private MyTree(double value) {
            this.value = value;
        }
    }
}

