/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;

@Export(value={"statistics"})
@Help(key="aggregation-statistics")
public class StatisticsAggregation
implements Aggregation<Row> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Double> expr;

    public StatisticsAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
    }

    private static double safe(double mean) {
        if (Double.isNaN(mean) || Double.isInfinite(mean)) {
            return 0.0;
        }
        return mean;
    }

    private static double safeRounded(double mean) {
        BigDecimal bd = new BigDecimal(StatisticsAggregation.safe(mean));
        bd = bd.setScale(10, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public Type<Row> type() {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo("n", (Type)Type.NUMBER), new FieldInfo("mean", (Type)Type.NUMBER), new FieldInfo("variance", (Type)Type.NUMBER), new FieldInfo("stdev", (Type)Type.NUMBER), new FieldInfo("skewness", (Type)Type.NUMBER), new FieldInfo("kurtosis", (Type)Type.NUMBER)})));
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        return "statistics(" + this.expr + ")";
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 40L;
    }

    public Row eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree mtree = (MyTree)tree;
        return new ArrayRow(new Object[]{(double)mtree.n, StatisticsAggregation.safeRounded(mtree.M1), StatisticsAggregation.safeRounded(mtree.M2 / (double)(mtree.n - 1L)), StatisticsAggregation.safeRounded(Math.sqrt(mtree.M2 / (double)(mtree.n - 1L))), StatisticsAggregation.safeRounded(Math.sqrt(mtree.n - 1L) * mtree.M3 / Math.pow(mtree.M2, 1.5)), StatisticsAggregation.safeRounded((double)(mtree.n - 1L) * mtree.M4 / (mtree.M2 * mtree.M2))});
    }

    public class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private long n;
        private volatile double M1;
        private volatile double M2;
        private volatile double M3;
        private volatile double M4;

        public void addQ(MyTree tree) {
            long nn = this.n + tree.n;
            double delta = tree.M1 - this.M1;
            double delta2 = delta * delta;
            double delta3 = delta * delta2;
            double delta4 = delta2 * delta2;
            double nM1 = ((double)this.n * this.M1 + (double)tree.n * tree.M1) / (double)nn;
            double nM2 = this.M2 + tree.M2 + delta2 * (double)this.n * (double)tree.n / (double)nn;
            double nM3 = this.M3 + tree.M3 + delta3 * (double)this.n * (double)tree.n * (double)(this.n - tree.n) / (double)(nn * nn);
            double nM4 = this.M4 + tree.M4 + delta4 * (double)this.n * (double)tree.n * (double)(this.n * this.n - this.n * tree.n + tree.n * tree.n) / (double)(nn * nn * nn);
            this.n = nn;
            this.M1 = StatisticsAggregation.safe(nM1);
            this.M2 = StatisticsAggregation.safe(nM2);
            this.M3 = StatisticsAggregation.safe(nM3 += 3.0 * delta * ((double)this.n * tree.M2 - (double)tree.n * this.M2) / (double)nn);
            this.M4 = StatisticsAggregation.safe(nM4 += 6.0 * delta2 * ((double)(this.n * this.n) * tree.M2 + (double)(tree.n * tree.n) * this.M2) / (double)(nn * nn) + 4.0 * delta * ((double)this.n * tree.M3 - (double)tree.n * this.M3) / (double)nn);
        }

        public void removeQ(MyTree tree) {
            this.addQ(new MyTree(-tree.n, tree.M1, -tree.M2, -tree.M3, -tree.M4));
        }

        public void clear() {
            this.n = 0L;
            this.M4 = 0.0;
            this.M3 = 0.0;
            this.M2 = 0.0;
            this.M1 = 0.0;
        }

        public MyTree get() {
            return new MyTree(this.n, this.M1, this.M2, this.M3, this.M4);
        }
    }

    public class MyState
    implements State {
        private volatile long n = 0L;
        private volatile double M1 = 0.0;
        private volatile double M2 = 0.0;
        private volatile double M3 = 0.0;
        private volatile double M4 = 0.0;

        public void yield(Scope parent, Object obj) {
            Double xx = (Double)StatisticsAggregation.this.expr.eval(parent, obj);
            if (xx == null) {
                return;
            }
            double x = xx;
            long n1 = this.n++;
            double delta = x - this.M1;
            double delta_n = delta / (double)this.n;
            double delta_n2 = delta_n * delta_n;
            double term1 = delta * delta_n * (double)n1;
            this.M1 += delta_n;
            this.M4 += term1 * delta_n2 * (double)(this.n * this.n - 3L * this.n + 3L) + 6.0 * delta_n2 * this.M2 - 4.0 * delta_n * this.M3;
            this.M3 += term1 * delta_n * (double)(this.n - 2L) - 3.0 * delta_n * this.M2;
            this.M2 += term1;
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.n, this.M1, this.M2, this.M3, this.M4);
            this.n = 0L;
            this.M4 = 0.0;
            this.M3 = 0.0;
            this.M2 = 0.0;
            this.M1 = 0.0;
            return tree;
        }
    }

    public static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final long n;
        private volatile double M1;
        private volatile double M2;
        private volatile double M3;
        private volatile double M4;

        public MyTree(long n, double M1, double M2, double M3, double M4) {
            this.n = n;
            this.M1 = M1;
            this.M2 = M2;
            this.M3 = M3;
            this.M4 = M4;
        }
    }
}

