/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.MacroModule;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToLiteral;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"stdev"})
@Help(key="aggregation-stdev")
public class StdevAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Double> expr;
    private final Aggregation<Double> impl;
    private final Scalar<Double> weight;

    public StdevAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        this.weight = (Scalar)queue.scalar((Type)Type.NUMBER).getOptional(new FallbackToLiteral(Type.NUMBER, 1.0));
        this.impl = (Aggregation)queue.compiler().expression().withModule((Module)new MacroModule(new Object[]{this.expr, this.weight})).compileToQueue(new String[]{"variance(@@0, @@1) ** 0.5"}).aggregation((Type)Type.NUMBER).get();
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        if (Level.CONSTANT.accepts(this.weight) && (Double)this.weight.eval(null, null) == 1.0) {
            return "stdev(" + this.expr + ")";
        }
        return "stdev(" + this.expr + ", " + this.weight + ")";
    }

    public State newState(int flips) {
        return this.impl.newState(flips);
    }

    public FullMerger newMerger() {
        return this.impl.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.impl.newInsertMerger();
    }

    public long ttl() {
        return this.impl.ttl();
    }

    public long weight() {
        return this.impl.weight();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.impl});
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (Double)this.impl.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.impl.visit(parent, visitor);
    }
}

