/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"sum"})
@Help(key="aggregation-sum")
public class SumAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Double> expr;

    public SumAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
    }

    public String toString() {
        return "sum(" + this.expr + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 8L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree t = (MyTree)tree;
        return t.value + t.compensation;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final double value;
        private final double compensation;

        public MyTree(double value, double compensation) {
            this.value = value;
            this.compensation = compensation;
        }
    }

    private class MyState
    implements State {
        private volatile double sum = 0.0;
        private volatile double compensation = 0.0;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Double newValue = (Double)SumAggregation.this.expr.eval(parent, obj);
            if (newValue != null) {
                double t = this.sum + newValue;
                this.compensation = Math.abs(this.sum) >= Math.abs(newValue) ? (this.compensation += this.sum - t + newValue) : (this.compensation += newValue - t + this.sum);
                this.sum = t;
            }
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.sum, this.compensation);
            this.sum = 0.0;
            this.compensation = 0.0;
            return tree;
        }
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private double sum = 0.0;
        private double compensation = 0.0;

        private MyMerger() {
        }

        private void kadd(double newValue) {
            double t = this.sum + newValue;
            this.compensation = Math.abs(this.sum) >= Math.abs(newValue) ? (this.compensation += this.sum - t + newValue) : (this.compensation += newValue - t + this.sum);
            this.sum = t;
        }

        public void addQ(MyTree tree) {
            this.kadd(tree.value);
            this.kadd(tree.compensation);
        }

        public void removeQ(MyTree tree) {
            this.kadd(-tree.value);
            this.kadd(-tree.compensation);
        }

        public void clear() {
            this.sum = 0.0;
            this.compensation = 0.0;
        }

        public MyTree get() {
            return new MyTree(this.sum, this.compensation);
        }
    }
}

