/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.ComparableAtom;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SortField;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.guava.collect.Ordering;
import net.intelie.pipes.modules.FallbackToSortField;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"top"})
@Help(key="aggregation-top")
public class TopAggregation
implements Aggregation<Iterable> {
    public static final Ordering<Comparable> QUEUE_ORDERING = Ordering.natural().nullsFirst().reverse();
    private static final long serialVersionUID = 1L;
    private final int n;
    private final Scalar<Object> expr;
    private final SortField[] sorters;

    public TopAggregation(ArgQueue queue) throws PipeException {
        this.n = ((Double)queue.constantValue((Type)Type.NUMBER).get()).intValue();
        PipeException.check((this.n > 0 ? 1 : 0) != 0, (Object)"Top number must be greater than zero.");
        this.expr = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        SortField[] localSorters = (SortField[])queue.arraySafe(SortField.class, (Fallback)new FallbackToSortField());
        if (localSorters.length == 0) {
            localSorters = (SortField[])queue.compiler().compileToQueue(new AstNode[]{new RawNode(this.expr)}).arraySafe(SortField.class, (Fallback)new FallbackToSortField());
        }
        this.sorters = localSorters;
    }

    public Type<Iterable> type() {
        return new SeqType(this.expr.type());
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyMerger();
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public String toString() {
        return "top(" + this.n + ", " + this.expr + ", " + Iterables.join((String)", ", (Object[])this.sorters) + ")";
    }

    public long weight() {
        return (1 + this.sorters.length) * 32;
    }

    public Iterable eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ComparableAtom.extract((List)((MyTree)tree).list);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (SortField sorter : this.sorters) {
            sorter.visit(parent, visitor);
        }
        return this.expr.visit(parent, visitor);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    private class MyMerger
    extends InsertMerger.Base<MyTree> {
        private final PriorityQueue<ComparableAtom> Q;

        private MyMerger() {
            this.Q = new PriorityQueue<Comparable>(TopAggregation.this.n, QUEUE_ORDERING);
        }

        public void clear() {
            this.Q.clear();
        }

        public void pushQ(MyTree tree) {
            for (ComparableAtom atom : tree.list) {
                if (this.Q.size() >= TopAggregation.this.n && atom.compareTo(this.Q.peek()) < 0) {
                    this.Q.poll();
                }
                if (this.Q.size() >= TopAggregation.this.n) continue;
                this.Q.add(atom);
            }
        }

        public MyTree get() {
            ArrayList<ComparableAtom> list = new ArrayList<ComparableAtom>(TopAggregation.this.n);
            list.addAll(this.Q);
            Collections.reverse(list);
            return new MyTree(list);
        }
    }

    private class MyState
    implements State {
        private PriorityQueue<ComparableAtom> Q;

        private MyState() {
            this.Q = new PriorityQueue<Comparable>(TopAggregation.this.n, QUEUE_ORDERING);
        }

        public void yield(Scope parent, Object obj) {
            ComparableAtom atom = ComparableAtom.create((Object)TopAggregation.this.expr.eval(parent, obj), (Scope)parent, (Object)obj, (Evaluable[])TopAggregation.this.sorters);
            if (this.Q.size() >= TopAggregation.this.n && atom.compareTo(this.Q.peek()) < 0) {
                this.Q.poll();
            }
            if (this.Q.size() < TopAggregation.this.n) {
                this.Q.add(atom);
            }
        }

        public Tree flip() {
            ArrayList<ComparableAtom> list = new ArrayList<ComparableAtom>(TopAggregation.this.n);
            while (!this.Q.isEmpty()) {
                list.add(this.Q.poll());
            }
            Collections.reverse(list);
            return new MyTree(list);
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final List<ComparableAtom> list;

        private MyTree(List<ComparableAtom> list) {
            this.list = list;
        }
    }
}

