/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToLiteral;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"variance"})
@Help(key="aggregation-variance")
public class VarianceAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Double> expr;
    private final Scalar<Double> weight;

    public VarianceAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        this.weight = (Scalar)queue.scalar((Type)Type.NUMBER).getOptional(new FallbackToLiteral(Type.NUMBER, 1.0));
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long weight() {
        return 24L;
    }

    public String toString() {
        if (Level.CONSTANT.accepts(this.weight) && Double.valueOf(1.0).equals(this.weight.eval(null, null))) {
            return "variance(" + this.expr + ")";
        }
        return "variance(" + this.expr + ", " + this.weight + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return Math.max(this.expr.ttl(), this.weight.ttl());
    }

    private static double safe(double mean) {
        return Double.isNaN(mean) || Double.isInfinite(mean) ? 0.0 : mean;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr, this.weight});
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree myTree = (MyTree)tree;
        if (Math.abs(myTree.sumw) < 1.0E-6) {
            return 0.0;
        }
        return myTree.m2 / myTree.sumw;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.weight.visit(parent, visitor);
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile double sumw = 0.0;
        private volatile double mean = 0.0;
        private volatile double m2 = 0.0;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            double nx = this.sumw + tree.sumw;
            double deltax = tree.mean - this.mean;
            double meanx = this.mean + deltax * (tree.sumw / nx);
            double m2x = this.m2 + tree.m2 + deltax * deltax * (this.sumw * tree.sumw / nx);
            this.sumw = nx;
            this.mean = meanx;
            this.m2 = m2x;
            this.mean = VarianceAggregation.safe(this.mean);
            this.m2 = VarianceAggregation.safe(this.m2);
        }

        public void removeQ(MyTree tree) {
            this.addQ(new MyTree(-tree.sumw, tree.mean, -tree.m2));
        }

        public void clear() {
            this.sumw = 0.0;
            this.mean = 0.0;
            this.m2 = 0.0;
        }

        public MyTree get() {
            return new MyTree(this.sumw, this.mean, this.m2);
        }
    }

    private class MyState
    implements State {
        private volatile double sumw = 0.0;
        private volatile double mean = 0.0;
        private volatile double m2 = 0.0;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Double w = (Double)VarianceAggregation.this.weight.eval(parent, obj);
            if (w == null) {
                return;
            }
            double temp = this.sumw + w;
            Double x = (Double)VarianceAggregation.this.expr.eval(parent, obj);
            if (x == null) {
                return;
            }
            double delta = x - this.mean;
            double r = delta * (w / temp);
            this.mean += r;
            this.m2 += this.sumw * delta * r;
            this.sumw = temp;
            this.mean = VarianceAggregation.safe(this.mean);
            this.m2 = VarianceAggregation.safe(this.m2);
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.sumw, this.mean, this.m2);
            this.sumw = 0.0;
            this.mean = 0.0;
            this.m2 = 0.0;
            return tree;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final double sumw;
        private final double mean;
        private final double m2;

        private MyTree(double sumw, double mean, double m2) {
            this.sumw = sumw;
            this.mean = mean;
            this.m2 = m2;
        }
    }
}

