/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.guava.primitives.Doubles;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"when"})
@Help(key="aggregation-when")
public class WhenAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Property<Double> timestamp;
    private final Scalar<Boolean> expr;
    private final int multiplier;

    public WhenAggregation(ArgQueue queue) throws PipeException {
        this((Property<Double>)queue.context().timestamp(), (Scalar<Boolean>)((Scalar)queue.scalar((Type)Type.BOOLEAN).get()), 1);
    }

    public WhenAggregation(Property<Double> timestamp, Scalar<Boolean> expr, int multiplier) {
        this.timestamp = timestamp;
        this.expr = expr;
        this.multiplier = multiplier;
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyMerger();
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public String toString() {
        return "when(" + this.expr + ")";
    }

    public long weight() {
        return 8L;
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ((MyTree)tree).last;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return this.timestamp.visit(parent, visitor);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    private class MyMerger
    extends InsertMerger.Base<MyTree> {
        private MyTree tree = null;

        private MyMerger() {
        }

        public void pushQ(MyTree tree) {
            if (tree.last == null) {
                return;
            }
            if (this.tree == null || WhenAggregation.this.multiplier * Doubles.compare(tree.last, this.tree.last) > 0) {
                this.tree = tree;
            }
        }

        public void clear() {
            this.tree = null;
        }

        public MyTree get() {
            if (this.tree == null) {
                return new MyTree(null);
            }
            return this.tree;
        }
    }

    private class MyState
    implements State {
        private Double last = null;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Double candidate;
            if (Boolean.TRUE.equals(WhenAggregation.this.expr.eval(parent, obj)) && (candidate = (Double)WhenAggregation.this.timestamp.eval(parent, obj)) != null && (this.last == null || WhenAggregation.this.multiplier * Double.compare(this.last, candidate) < 0)) {
                this.last = candidate;
            }
        }

        public Tree flip() {
            MyTree mergeable = new MyTree(this.last);
            this.last = null;
            return mergeable;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Double last;

        private MyTree(Double last) {
            this.last = last;
        }
    }
}

