/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.EmptyMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

public abstract class WindowAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new EmptyMerger();
    }

    public InsertMerger newInsertMerger() {
        return new EmptyMerger();
    }

    public abstract double calculate(WindowBounds var1);

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 0L;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return visitor.newScope();
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (bounds == null) {
            return null;
        }
        return this.calculate(bounds);
    }

    public void validate(ValidationContext context) throws PipeException {
    }

    private class MyState
    implements State {
        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
        }

        public Tree flip() {
            return null;
        }
    }

    @Export(value={"otimestamp", "OTIMESTAMP"})
    @Help(key="aggregation-otimestamp")
    public static class OTimestamp
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public OTimestamp(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.timestamp().longValue();
        }

        public String toString() {
            return "otimestamp()";
        }
    }

    @Export(value={"oend", "OEND"})
    @Help(key="aggregation-oend")
    public static class OEnd
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public OEnd(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.outputEnd();
        }

        public String toString() {
            return "oend()";
        }
    }

    @Export(value={"ostart", "OSTART"})
    @Help(key="aggregation-ostart")
    public static class OStart
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public OStart(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.outputStart();
        }

        public String toString() {
            return "ostart()";
        }
    }

    @Export(value={"wcount", "WCOUNT"})
    @Help(key="aggregation-wcount")
    public static class WCount
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public WCount(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.windowCount();
        }

        public String toString() {
            return "wcount()";
        }
    }

    @Export(value={"wend", "WEND"})
    @Help(key="aggregation-wend")
    public static class WEnd
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public WEnd(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.windowEnd();
        }

        public String toString() {
            return "wend()";
        }
    }

    @Export(value={"wstart", "WSTART"})
    @Help(key="aggregation-wstart")
    public static class WStart
    extends WindowAggregation {
        private static final long serialVersionUID = 1L;

        public WStart(ArgQueue queue) {
        }

        @Override
        public double calculate(WindowBounds bounds) {
            return bounds.windowStart();
        }

        public String toString() {
            return "wstart()";
        }
    }
}

