/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.dcount.HLLTree;
import net.intelie.pipes.aggregations.dcount.HyperLogLog;
import net.intelie.pipes.aggregations.dcount.SimpleHLLMerger;
import net.intelie.pipes.types.Level;

public abstract class BaseHLLAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;

    public Level level() {
        return Level.AGGREGATION;
    }

    public abstract State newState(int var1);

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public abstract long ttl();

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        HLLTree myTree = (HLLTree)tree;
        return this.eval(myTree.log());
    }

    public abstract T eval(HyperLogLog var1);

    private class MyInsertMerger
    extends InsertMerger.Base<HLLTree> {
        private final SimpleHLLMerger merger = new SimpleHLLMerger();

        private MyInsertMerger() {
        }

        public void clear() {
            this.merger.clear();
        }

        public void pushQ(HLLTree tree) {
            this.merger.add(tree.log());
        }

        public HLLTree get() {
            return new HLLTree(this.merger.get());
        }
    }
}

