/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.aggregations.dcount.BaseHLLAggregation;
import net.intelie.pipes.aggregations.dcount.CreateHLLState;

public abstract class CreateHLLAggregation<T>
extends BaseHLLAggregation<T> {
    private static final long serialVersionUID = 1L;
    private final int log2m;
    private final Scalar[] exprs;

    public CreateHLLAggregation(int log2m, Scalar[] exprs) throws PipeException {
        PipeException.check((log2m >= 6 && log2m <= 16 ? 1 : 0) != 0, (String)"Precision (log2m = %s) must be between 6 and 16.", (Object[])new Object[]{log2m});
        this.log2m = log2m;
        this.exprs = exprs;
    }

    public int log2m() {
        return this.log2m;
    }

    public Scalar[] exprs() {
        return this.exprs;
    }

    @Override
    public State newState(int flips) {
        return new CreateHLLState(this.log2m, this.exprs());
    }

    @Override
    public long ttl() {
        long maxx = 0L;
        for (Scalar expr : this.exprs()) {
            maxx = Math.max(maxx, expr.ttl());
        }
        return maxx;
    }

    public long weight() {
        return 1L << this.log2m;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (Scalar expr : this.exprs) {
            expr.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer((Expression[])this.exprs);
    }
}

