/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.aggregations.dcount.HLLTree;
import net.intelie.pipes.aggregations.dcount.HyperLogLog;
import net.intelie.pipes.guava.base.Charsets;
import net.intelie.pipes.util.MurmurHash;

public class CreateHLLState
implements State {
    private volatile HyperLogLog log;
    private final int log2m;
    private final Scalar[] exprs;

    public CreateHLLState(int log2m, Scalar[] exprs) {
        this.log2m = log2m;
        this.exprs = exprs;
        this.log = this.newLog();
    }

    private HyperLogLog newLog() {
        return new HyperLogLog(this.log2m);
    }

    public void yield(Scope parent, Object obj) {
        this.yieldLogLog(parent, obj);
    }

    private void yieldLogLog(Scope parent, Object obj) {
        int hash = 0;
        int seed = 0;
        for (Scalar expr : this.exprs) {
            Object o = expr.eval(parent, obj);
            hash ^= CreateHLLState.hashValue(seed, o);
            ++seed;
        }
        this.log.offer(hash);
    }

    public static int hashValue(int seed, Object o) {
        seed = MurmurHash.hashLong(seed, 0);
        if (o == null) {
            return 0;
        }
        if (o instanceof Double) {
            return MurmurHash.hashLong(Double.doubleToLongBits((Double)o), seed);
        }
        if (o instanceof Boolean) {
            return MurmurHash.hashLong((Boolean)o != false ? 0L : -1L, seed);
        }
        return MurmurHash.hash(o.toString().getBytes(Charsets.UTF_8), seed);
    }

    public Tree flip() {
        HLLTree myMergeable = new HLLTree(this.log);
        this.log = this.newLog();
        return myMergeable;
    }
}

