/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.dcount.CreateHLLState;
import net.intelie.pipes.aggregations.dcount.HLLMerger;
import net.intelie.pipes.aggregations.dcount.HyperLogLog;
import net.intelie.pipes.aggregations.dcount.SimpleHLLMerger;
import net.intelie.pipes.guava.collect.HashMultiset;
import net.intelie.pipes.guava.collect.Multiset;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"dcount"})
@Help(key="aggregation-dcount")
public class DCountAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final int threshold;
    private final Scalar[] exprs;

    public DCountAggregation(ArgQueue queue) throws PipeException {
        this(1024, queue);
    }

    public DCountAggregation(int threshold, ArgQueue queue) throws PipeException {
        this.threshold = threshold;
        this.exprs = (Scalar[])queue.scalar((Type)Type.OBJECT).array();
    }

    public State newState(int flips) {
        return new MyState(flips);
    }

    public InsertMerger newInsertMerger() {
        return new MyMerger();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public String toString() {
        return "dcount(" + Iterables.join((String)", ", (Object[])this.exprs) + ")";
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (tree instanceof DeterministicTree) {
            DeterministicTree myTree = (DeterministicTree)tree;
            return myTree.S.size();
        }
        SketchTree myTree = (SketchTree)tree;
        return myTree.sketch.cardinality();
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (Scalar scalar : this.exprs) {
            scalar.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 65536L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer((Expression[])this.exprs);
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    private void fillSketch(Set set, HyperLogLog sketch) {
        for (Object value : set) {
            int hash = 0;
            int seed = 0;
            if (this.exprs.length == 1 || !(value instanceof Iterable)) {
                hash ^= CreateHLLState.hashValue(0, value);
            } else {
                for (Object o : (Iterable)value) {
                    hash ^= CreateHLLState.hashValue(seed++, o);
                }
            }
            sketch.offer(hash);
        }
    }

    private class MyMerger
    extends InsertMerger.Base<Tree> {
        private final Multiset<DeterministicTree> set = HashMultiset.create();
        private HLLMerger sketch = null;
        private int count = 0;

        private MyMerger() {
        }

        public void pushQ(Tree tree) {
            if (tree instanceof DeterministicTree) {
                DeterministicTree myTree = (DeterministicTree)tree;
                this.count += myTree.S.size();
                if (this.sketch == null && this.count > DCountAggregation.this.threshold) {
                    this.initalizeSketch();
                }
                if (this.sketch == null) {
                    this.set.add(myTree);
                } else {
                    HyperLogLog hll = new HyperLogLog(12);
                    DCountAggregation.this.fillSketch(myTree.S, hll);
                    this.sketch.add(hll);
                }
            } else {
                SketchTree myTree = (SketchTree)tree;
                this.count += myTree.sketch.total();
                if (this.sketch == null) {
                    this.initalizeSketch();
                }
                this.sketch.add(myTree.sketch);
            }
        }

        private void initalizeSketch() {
            this.sketch = new SimpleHLLMerger();
            HyperLogLog hll = new HyperLogLog(12);
            for (DeterministicTree tree : this.set) {
                DCountAggregation.this.fillSketch(tree.S, hll);
            }
            this.sketch.add(hll);
            this.set.clear();
        }

        public Tree get() {
            if (this.sketch == null) {
                HashSet finalSet = new HashSet();
                for (DeterministicTree tree : this.set) {
                    finalSet.addAll(tree.S);
                }
                return new DeterministicTree(finalSet);
            }
            return new SketchTree(this.sketch.get());
        }

        public void clear() {
            this.set.clear();
            this.count = 0;
            this.sketch = null;
        }
    }

    private class MyState
    implements State {
        private HyperLogLog sketch = null;
        private Set S = new HashSet();

        public MyState(int flips) {
        }

        public void yield(Scope parent, Object obj) {
            if (this.sketch == null && this.S.size() >= DCountAggregation.this.threshold) {
                this.sketch = new HyperLogLog(12);
                DCountAggregation.this.fillSketch(this.S, this.sketch);
                this.S.clear();
            }
            if (this.sketch != null) {
                int seed = 0;
                int hash = 0;
                for (Scalar expr : DCountAggregation.this.exprs) {
                    Object o = expr.eval(parent, obj);
                    hash ^= CreateHLLState.hashValue(seed, o);
                    ++seed;
                }
                this.sketch.offer(hash);
            } else {
                this.S.add(this.findValue(parent, obj));
            }
        }

        private Object findValue(Scope parent, Object obj) {
            ArrayList<Object> value;
            if (DCountAggregation.this.exprs.length == 1) {
                value = DCountAggregation.this.exprs[0].eval(parent, obj);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Scalar expr : DCountAggregation.this.exprs) {
                    list.add(expr.eval(parent, obj));
                }
                value = list;
            }
            return value;
        }

        public Tree flip() {
            Tree tree = this.makeTree();
            this.sketch = null;
            this.S.clear();
            return tree;
        }

        private Tree makeTree() {
            if (this.sketch != null) {
                return new SketchTree(this.sketch);
            }
            HashSet copyOfS = new HashSet(this.S);
            return new DeterministicTree(copyOfS);
        }
    }

    private static class SketchTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final HyperLogLog sketch;

        public SketchTree(HyperLogLog sketch) {
            this.sketch = sketch;
        }
    }

    private static class DeterministicTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Set S;

        public DeterministicTree(Set S) {
            this.S = S;
        }
    }
}

