/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.aggregations.dcount.BaseHLLAggregation;
import net.intelie.pipes.aggregations.dcount.HyperLogLog;
import net.intelie.pipes.aggregations.dcount.MergeHLLState;
import net.intelie.pipes.types.Type;

@Export(value={"hll.merge"})
@Help(key="aggregation-hll-merge")
public class HLLMergeAggregation
extends BaseHLLAggregation<String> {
    private static final long serialVersionUID = 1L;
    private final Scalar<String> expr;

    public HLLMergeAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.STRING).get();
    }

    public String toString() {
        return "hll.merge(" + this.expr + ")";
    }

    @Override
    public State newState(int flips) {
        return new MergeHLLState(this.expr);
    }

    @Override
    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 65536L;
    }

    @Override
    public String eval(HyperLogLog hll) {
        if (hll == null) {
            return null;
        }
        return hll.toCompressedString();
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    public Type<String> type() {
        return Type.STRING;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }
}

