/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import java.io.Serializable;
import net.intelie.pipes.util.ArrayCompressor;

public class HyperLogLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] M;
    private final int log2m;
    private final double alphaMM;
    private final int SAFEBIT;
    private int total = 0;

    public HyperLogLog(double rsd) {
        this(HyperLogLog.log2m(rsd));
    }

    public HyperLogLog(int log2m) {
        this(log2m, new byte[1 << log2m]);
    }

    public HyperLogLog(int log2m, byte[] M) {
        this.M = M;
        this.log2m = log2m;
        this.alphaMM = this.setAlphaMM(M.length);
        this.SAFEBIT = 1 << this.log2m - 1;
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    public static HyperLogLog fromCompressedString(String s) {
        byte[] bytes = ArrayCompressor.decompressToBytes(s);
        if (bytes == null) {
            return null;
        }
        int log2m = Integer.numberOfTrailingZeros(Integer.highestOneBit(bytes.length));
        if (bytes.length != 1 << log2m) {
            return null;
        }
        return new HyperLogLog(log2m, bytes);
    }

    private double setAlphaMM(double m) {
        return 0.7213 / (1.0 + 1.079 / m) * m * m;
    }

    public boolean offer(int x) {
        ++this.total;
        int j = x >>> 32 - this.log2m;
        byte r = (byte)(Integer.numberOfLeadingZeros(x << this.log2m | this.SAFEBIT) + 1);
        if (r > this.M[j]) {
            this.M[j] = r;
            return true;
        }
        return false;
    }

    public long cardinality() {
        double sum = 0.0;
        int count = this.M.length;
        for (byte x : this.M) {
            sum += Math.pow(2.0, -x);
        }
        double estimate = this.alphaMM / sum;
        if (estimate <= 2.5 * (double)count) {
            double zeros = 0.0;
            for (byte aM : this.M) {
                if (aM != 0) continue;
                zeros += 1.0;
            }
            return Math.round((double)count * Math.log((double)count / zeros));
        }
        return Math.round(estimate);
    }

    public byte get(int i) {
        return this.M[i];
    }

    public int log2m() {
        return this.log2m;
    }

    public int size() {
        return this.M.length;
    }

    public String toCompressedString() {
        return ArrayCompressor.compress(this.M);
    }

    public int total() {
        return this.total;
    }

    public void copyTo(byte[] M) {
        System.arraycopy(this.M, 0, M, 0, Math.min(this.M.length, M.length));
    }
}

