/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.dcount;

import java.util.Arrays;
import net.intelie.pipes.aggregations.dcount.HLLMerger;
import net.intelie.pipes.aggregations.dcount.HyperLogLog;

public class SimpleHLLMerger
implements HLLMerger {
    private byte[] M = null;
    private int log2m = -1;

    @Override
    public void add(HyperLogLog hll) {
        if (hll == null) {
            return;
        }
        if (!this.foldTo(hll)) {
            hll.copyTo(this.M);
        } else {
            int hsize = hll.size();
            for (int i = 0; i < hsize; ++i) {
                int idx = i & (1 << this.log2m) - 1;
                this.M[idx] = (byte)Math.max(this.M[idx], hll.get(i));
            }
        }
    }

    private boolean foldTo(HyperLogLog hll) {
        int hlog2m = hll.log2m();
        int hsize = 1 << hlog2m;
        if (this.M == null) {
            this.M = new byte[hsize];
        }
        if (this.log2m < 0) {
            this.log2m = hlog2m;
            return false;
        }
        if (hlog2m < this.log2m) {
            for (int i = hsize; i < this.M.length; ++i) {
                int idx = i & hsize - 1;
                this.M[idx] = (byte)Math.max(this.M[idx], this.M[i]);
            }
            this.log2m = hlog2m;
        }
        return true;
    }

    public HyperLogLog flip() {
        HyperLogLog hll = this.get();
        this.clear();
        return hll;
    }

    public void clear() {
        this.log2m = -1;
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
        }
    }

    @Override
    public HyperLogLog get() {
        return this.log2m > 0 ? new HyperLogLog(this.log2m, Arrays.copyOf(this.M, 1 << this.log2m)) : null;
    }
}

