/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.mregression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.mregression.Regression;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

public abstract class MRegressionBaseAggregation<T>
implements Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final List<Evaluable<Double>> vars;
    private final List<Scalar<Double>> originalVars;

    public MRegressionBaseAggregation(ArgQueue queue) throws PipeException {
        this.originalVars = Arrays.asList(queue.scalar((Type)Type.NUMBER).array());
        this.vars = new ArrayList<Evaluable<Double>>();
        this.vars.addAll(this.originalVars);
        PipeException.check((!this.vars.isEmpty() ? 1 : 0) != 0, (Object)"Must define at least one variable.");
        if (this.vars.size() == 1) {
            this.vars.add(0, (Evaluable<Double>)queue.context().timestamp());
        }
    }

    public abstract Type<T> type();

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString(String name) {
        return name + "(" + Iterables.join((String)", ", this.originalVars) + ")";
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(this.originalVars);
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        int n = this.vars.size();
        return n * n * 8 + n * 8 + 16;
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        Regression mtree = (Regression)tree;
        return this.evalRegression(mtree);
    }

    public abstract T evalRegression(Regression var1);

    private class MyMerger
    extends SimpleMerger.Base<Regression> {
        private final Regression regression;

        private MyMerger() {
            this.regression = new Regression(MRegressionBaseAggregation.this.vars.size());
        }

        public void addQ(Regression tree) {
            this.regression.add(tree);
        }

        public void removeQ(Regression tree) {
            this.regression.remove(tree);
        }

        public void clear() {
            this.regression.clear();
        }

        public Regression get() {
            return this.regression.copy();
        }
    }

    private class MyState
    implements State {
        private final Regression regression;

        private MyState() {
            this.regression = new Regression(MRegressionBaseAggregation.this.vars.size());
        }

        public void yield(Scope parent, Object obj) {
            double[] local = new double[MRegressionBaseAggregation.this.vars.size()];
            for (int i = 0; i < MRegressionBaseAggregation.this.vars.size(); ++i) {
                Evaluable var = (Evaluable)MRegressionBaseAggregation.this.vars.get(i);
                Double value = (Double)var.eval(parent, obj);
                local[i] = value != null ? value : 0.0;
            }
            this.regression.add(local);
        }

        public Tree flip() {
            Regression regression = this.regression.copy();
            this.regression.clear();
            return regression;
        }
    }
}

