/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.mregression;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.aggregations.mregression.DoubleArrays;
import net.intelie.pipes.aggregations.mregression.MRegressionBaseAggregation;
import net.intelie.pipes.aggregations.mregression.Regression;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={"mregression.full"})
@Help(key="aggregation-mregression-full")
public class MRegressionFullAggregation
extends MRegressionBaseAggregation<Row> {
    private static final long serialVersionUID = 1L;

    public MRegressionFullAggregation(ArgQueue queue) throws PipeException {
        super(queue);
    }

    public String toString() {
        return this.toString("mregression.full");
    }

    @Override
    public Type<Row> type() {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo("n", (Type)Type.NUMBER), new FieldInfo("coefficients", (Type)new SeqType((Type)Type.NUMBER)), new FieldInfo("correlation", (Type)new SeqType((Type)new SeqType((Type)Type.NUMBER))), new FieldInfo("covariance", (Type)new SeqType((Type)new SeqType((Type)Type.NUMBER))), new FieldInfo("mean", (Type)Type.NUMBER)})));
    }

    @Override
    public Row evalRegression(Regression mtree) {
        return new ArrayRow(new Object[]{(double)mtree.count(), DoubleArrays.box(mtree.coefficients()), DoubleArrays.box(mtree.correlation()), DoubleArrays.box(mtree.cov()), DoubleArrays.box(mtree.mean())});
    }
}

