/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.mregression;

import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.WithType;

public abstract class MRegressionFunctions {
    @Export(value={"mregression.apply"})
    @Help(key="scalar-mregression-apply")
    public static Double apply(@WithType(value="seq(number)") Iterable coefficients, Double ... xs) {
        if (coefficients == null) {
            return null;
        }
        double value = 0.0;
        int i = -1;
        for (Object coefficient : coefficients) {
            if (!(coefficient instanceof Number)) continue;
            double coeff = ((Number)coefficient).doubleValue();
            if (i < 0) {
                value += coeff;
            } else if (xs != null && i < xs.length) {
                value += xs[i] * coeff;
            }
            ++i;
        }
        return value;
    }
}

