/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.mregression;

import java.io.Serializable;
import java.util.Arrays;
import net.intelie.pipes.Tree;

public class Regression
implements Tree,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double[][] covn;
    private final double[] mean;
    private long n;

    public Regression(int variables) {
        this(new double[variables][variables], new double[variables], 0L);
    }

    private Regression(double[][] covn, double[] mean, long n) {
        this.covn = covn;
        this.mean = mean;
        this.n = n;
    }

    public int varCount() {
        return this.covn.length;
    }

    public void add(double ... xs) {
        int i;
        for (i = 0; i < xs.length; ++i) {
            for (int j = i; j < xs.length; ++j) {
                double[] dArray = this.covn[i];
                int n = j;
                double d = dArray[n] + (this.mean[i] - xs[i]) * (this.mean[j] - xs[j]) * (double)this.n / ((double)this.n + 1.0);
                dArray[n] = d;
                this.covn[j][i] = d;
            }
        }
        ++this.n;
        for (i = 0; i < xs.length; ++i) {
            int n = i;
            this.mean[n] = this.mean[n] + (xs[i] - this.mean[i]) / (double)this.n;
        }
    }

    public void add(Regression regression) {
        this.addInternal(regression, 1);
    }

    public void remove(Regression regression) {
        this.addInternal(regression, -1);
    }

    private void addInternal(Regression regression, int m) {
        int i;
        long nn = this.n + (long)m * regression.n;
        if (nn == 0L) {
            this.clear();
            return;
        }
        for (i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double xdelta = regression.mean[i] - this.mean[i];
                double ydelta = regression.mean[j] - this.mean[j];
                double d = this.covn[i][j] + (double)m * regression.covn[i][j] + (double)(this.n * (long)m * regression.n) * xdelta * ydelta / (double)nn;
                this.covn[j][i] = d;
                this.covn[i][j] = d;
            }
        }
        for (i = 0; i < this.mean.length; ++i) {
            this.mean[i] = ((double)this.n * this.mean[i] + (double)((long)m * regression.n) * regression.mean[i]) / (double)nn;
        }
        this.n = nn;
    }

    public void clear() {
        this.n = 0L;
        for (double[] A : this.covn) {
            Arrays.fill(A, 0.0);
        }
        Arrays.fill(this.mean, 0.0);
    }

    public Regression copy() {
        double[][] covn = new double[this.covn.length][];
        for (int i = 0; i < this.covn.length; ++i) {
            covn[i] = Arrays.copyOf(this.covn[i], this.covn[i].length);
        }
        return new Regression(covn, Arrays.copyOf(this.mean, this.mean.length), this.n);
    }

    public double[][] cov() {
        if (this.n <= 1L) {
            return null;
        }
        double[][] M = new double[this.covn.length][this.covn.length];
        for (int i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double d = this.covn[i][j] / (double)(this.n - 1L);
                M[j][i] = d;
                M[i][j] = d;
            }
        }
        return M;
    }

    public double[][] correlation() {
        int i;
        double[][] cov = this.cov();
        if (cov == null) {
            return null;
        }
        for (i = 0; i < cov.length; ++i) {
            for (int j = i + 1; j < cov.length; ++j) {
                double d = cov[i][j] / (Math.sqrt(cov[i][i]) * Math.sqrt(cov[j][j]));
                cov[j][i] = d;
                cov[i][j] = d;
            }
        }
        for (i = 0; i < cov.length; ++i) {
            cov[i][i] = 1.0;
        }
        return cov;
    }

    public double[] coefficients() {
        double[][] cov = this.cov();
        if (cov == null) {
            return null;
        }
        int n = cov.length - 1;
        int[] P = new int[n];
        int m = this.filterIndependentVariables(cov, n, P);
        if (!this.solve(cov, m)) {
            return null;
        }
        return this.finalizeCoefficients(cov, n, m, P);
    }

    private double[] finalizeCoefficients(double[][] cov, int n, int m, int[] P) {
        int i;
        double intercept = this.mean[this.mean.length - 1];
        for (int i2 = 0; i2 < m; ++i2) {
            intercept -= cov[i2][m] * this.mean[P[i2]];
        }
        double[] coeficients = cov[n];
        coeficients[0] = intercept;
        for (i = 0; i < n; ++i) {
            coeficients[i + 1] = 0.0;
        }
        for (i = 0; i < m; ++i) {
            coeficients[P[i] + 1] = cov[i][m];
        }
        return coeficients;
    }

    private int filterIndependentVariables(double[][] cov, int n, int[] P) {
        int i;
        int k = 0;
        for (i = 0; i < n; ++i) {
            boolean independent = true;
            for (int j = 0; j < i; ++j) {
                double xy = cov[i][j] / (double)(n - 1);
                double xx = cov[i][i] / (double)(n - 1);
                double yy = cov[j][j] / (double)(n - 1);
                if (!(Math.abs(Math.abs(xy * xy / xx / yy) - 1.0) < 1.0E-6)) continue;
                independent = false;
            }
            if (!independent) continue;
            P[k++] = i;
        }
        for (i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                cov[i][j] = cov[P[i]][P[j]];
            }
        }
        for (i = 0; i < k; ++i) {
            cov[i][k] = cov[P[i]][n];
        }
        return k;
    }

    private boolean solve(double[][] A, int n) {
        for (int i = 0; i < n; ++i) {
            int j;
            int max = i;
            for (j = i + 1; j < n; ++j) {
                if (!(Math.abs(A[j][i]) > Math.abs(A[max][i]))) continue;
                max = j;
            }
            this.swap(i, max, A);
            if (A[i][i] == 0.0) {
                return false;
            }
            for (j = i + 1; j < n; ++j) {
                double m = A[j][i] / A[i][i];
                for (int k = i + 1; k < n + 1; ++k) {
                    double[] dArray = A[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - A[i][k] * m;
                }
                A[j][i] = 0.0;
            }
        }
        for (int j = n - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < n; ++k) {
                t += A[j][k] * A[k][n];
            }
            A[j][n] = (A[j][n] - t) / A[j][j];
        }
        return true;
    }

    private void swap(int i, int j, double[][] M) {
        double[] temp = M[i];
        M[i] = M[j];
        M[j] = temp;
    }

    public long count() {
        return this.n;
    }

    public double[] mean() {
        if (this.n == 0L) {
            return null;
        }
        return this.mean;
    }
}

