/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.quantile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.quantile.QuantileSketch;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.FullMergerAdaptor;

@Export(value={"quantile"})
@Help(key="aggregation-quantile")
public class QuantileAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final int threshold;
    private final Scalar<Double> expr;
    private final Aggregation<Double> quantile;

    public QuantileAggregation(ArgQueue queue) throws PipeException {
        this(65536, queue);
    }

    public QuantileAggregation(int threshold, ArgQueue queue) throws PipeException {
        this.threshold = threshold;
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        this.quantile = (Aggregation)queue.aggregation((Type)Type.NUMBER).get();
    }

    public State newState(int flips) {
        return new MyState(flips);
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger(this.quantile.newMerger()));
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger((FullMerger)new FullMergerAdaptor(this.quantile.newInsertMerger())));
    }

    public String toString() {
        return "quantile(" + this.expr + ", " + this.quantile + ")";
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (tree instanceof DeterministicTree) {
            DeterministicTree myTree = (DeterministicTree)tree;
            if (myTree.A.length == 0) {
                return 0.0;
            }
            Double quantileValue = (Double)this.quantile.eval(parent, myTree.quantile, bounds);
            if (quantileValue == null) {
                return null;
            }
            double index = quantileValue * (double)myTree.A.length;
            int second = (int)Math.round(index);
            int first = Math.max(second - 1, 0);
            first = Math.min(Math.max(first, 0), myTree.A.length - 1);
            if (Math.abs(index - (double)(second = Math.min(Math.max(second, 0), myTree.A.length - 1))) < 1.0E-6) {
                return (myTree.A[first] + myTree.A[second]) / 2.0;
            }
            return myTree.A[first];
        }
        SketchTree myTree = (SketchTree)tree;
        Double quantileValue = (Double)this.quantile.eval(parent, myTree.quantile, bounds);
        if (quantileValue == null) {
            return null;
        }
        return myTree.sketch.quantile(quantileValue);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        this.quantile.visit(parent, visitor);
        return visitor.newScope();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 524288L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr, this.quantile});
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    private class MyMerger
    extends SimpleMerger.Base<Tree> {
        private final FullMerger quantileMerger;
        private final Set<double[]> set = new HashSet<double[]>();
        private QuantileSketch sketch = null;
        private int count = 0;
        private int adds = 0;

        private MyMerger(FullMerger quantileMerger) {
            this.quantileMerger = quantileMerger;
        }

        public void addQ(Tree tree) {
            if (tree instanceof DeterministicTree) {
                DeterministicTree myTree = (DeterministicTree)tree;
                this.quantileMerger.push(myTree.quantile);
                this.count += myTree.A.length;
                if (this.sketch == null && this.count > QuantileAggregation.this.threshold) {
                    this.initalizeSketch();
                }
                if (this.sketch == null) {
                    this.set.add(myTree.A);
                } else {
                    for (double v : myTree.A) {
                        this.sketch.offer(v);
                    }
                }
            } else {
                SketchTree myTree = (SketchTree)tree;
                this.quantileMerger.push(myTree.quantile);
                this.count += myTree.sketch.total();
                if (this.sketch == null) {
                    this.initalizeSketch();
                }
                this.sketch.add(myTree.sketch);
            }
            ++this.adds;
        }

        private void initalizeSketch() {
            this.sketch = new QuantileSketch();
            for (double[] array : this.set) {
                for (double v : array) {
                    this.sketch.offer(v);
                }
            }
            this.set.clear();
        }

        public void removeQ(Tree tree) {
            if (tree instanceof DeterministicTree) {
                DeterministicTree myTree = (DeterministicTree)tree;
                this.quantileMerger.pop();
                this.count -= myTree.A.length;
                if (this.sketch == null) {
                    this.set.remove(myTree.A);
                } else {
                    for (double v : myTree.A) {
                        this.sketch.offer(v, -1);
                    }
                }
            } else {
                SketchTree myTree = (SketchTree)tree;
                this.quantileMerger.pop();
                this.count -= myTree.sketch.total();
                this.sketch.remove(myTree.sketch);
            }
            if (--this.adds == 0) {
                this.clear();
            }
        }

        public Tree get() {
            if (this.sketch == null) {
                PriorityQueue<ComparableArray> Q = new PriorityQueue<ComparableArray>();
                int resultSize = 0;
                for (double[] array : this.set) {
                    if (array.length > 0) {
                        Q.add(new ComparableArray(array, 0));
                    }
                    resultSize += array.length;
                }
                double[] result = new double[resultSize];
                int index = 0;
                while (!Q.isEmpty()) {
                    ComparableArray array = (ComparableArray)Q.poll();
                    result[index++] = array.arr[array.index++];
                    if (array.index >= array.arr.length) continue;
                    Q.add(array);
                }
                return new DeterministicTree(this.quantileMerger.get(), result);
            }
            return new SketchTree(this.quantileMerger.get(), this.sketch.copy());
        }

        public void clear() {
            this.quantileMerger.clear();
            this.set.clear();
            this.count = 0;
            this.adds = 0;
            this.sketch = null;
        }
    }

    private class MyState
    implements State {
        private final State quantileState;
        private QuantileSketch sketch;
        private double[] A;
        private int count;

        public MyState(int flips) {
            this.quantileState = QuantileAggregation.this.quantile.newState(flips);
            this.sketch = null;
            this.A = new double[16];
            this.count = 0;
        }

        public void yield(Scope parent, Object obj) {
            this.quantileState.yield(parent, obj);
            Double value = (Double)QuantileAggregation.this.expr.eval(parent, obj);
            if (value == null) {
                return;
            }
            if (this.sketch == null && this.count >= QuantileAggregation.this.threshold) {
                this.sketch = new QuantileSketch();
                for (int i = 0; i < this.count; ++i) {
                    this.sketch.offer(this.A[i]);
                }
            }
            if (this.sketch != null) {
                this.sketch.offer(value);
            } else {
                if (this.count == this.A.length) {
                    this.A = Arrays.copyOf(this.A, this.A.length * 2);
                }
                this.A[this.count++] = value;
            }
        }

        public Tree flip() {
            Tree tree = this.makeTree();
            this.count = 0;
            this.sketch = null;
            return tree;
        }

        private Tree makeTree() {
            Tree quantileTree = this.quantileState.flip();
            if (this.sketch != null) {
                return new SketchTree(quantileTree, this.sketch);
            }
            double[] copyOfA = Arrays.copyOf(this.A, this.count);
            Arrays.sort(copyOfA);
            return new DeterministicTree(quantileTree, copyOfA);
        }
    }

    private static class ComparableArray
    implements Comparable<ComparableArray> {
        private final double[] arr;
        private int index;

        public ComparableArray(double[] arr, int index) {
            this.arr = arr;
            this.index = index;
        }

        @Override
        public int compareTo(ComparableArray that) {
            return Double.compare(this.arr[this.index], that.arr[that.index]);
        }
    }

    private static class SketchTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Tree quantile;
        private final QuantileSketch sketch;

        public SketchTree(Tree quantile, QuantileSketch sketch) {
            this.quantile = quantile;
            this.sketch = sketch;
        }
    }

    private static class DeterministicTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Tree quantile;
        private final double[] A;

        public DeterministicTree(Tree quantile, double[] A) {
            this.quantile = quantile;
            this.A = A;
        }
    }
}

