/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.quantile;

import java.io.Serializable;
import java.util.Arrays;
import net.intelie.pipes.util.MurmurHash;

public class QuantileSketch
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final double e;
    private final int width;
    private final int[] M;
    private final int mask;
    private volatile int total;

    public QuantileSketch() {
        this(16);
    }

    private QuantileSketch(int log2w) {
        this(1 << log2w, new int[(1 << log2w) * 2], 0);
    }

    private QuantileSketch(int width, int[] m, int total) {
        this.width = width;
        this.M = m;
        this.mask = width - 1;
        this.e = Math.E / (double)width;
        this.total = total;
    }

    public void add(QuantileSketch sketch) {
        this.total += sketch.total;
        int[] otherM = sketch.M;
        for (int i = 0; i < otherM.length; ++i) {
            int n = i;
            this.M[n] = this.M[n] + otherM[i];
        }
    }

    public void remove(QuantileSketch sketch) {
        this.total -= sketch.total;
        int[] otherM = sketch.M;
        for (int i = 0; i < otherM.length; ++i) {
            int n = i;
            this.M[n] = this.M[n] - otherM[i];
        }
    }

    public int total() {
        return this.total;
    }

    public void clear() {
        this.total = 0;
        Arrays.fill(this.M, 0);
    }

    public QuantileSketch copy() {
        return new QuantileSketch(this.width, Arrays.copyOf(this.M, this.M.length), this.total);
    }

    public void offer(double value) {
        this.offer(value, 1);
    }

    public void offer(double value, int weight) {
        for (long k = this.makeK(value); k != 0L; k += k & -k) {
            this.innerAdd(k, weight);
        }
        this.total += weight;
    }

    private long makeK(double value) {
        return -((long)(value * 1000.0)) ^ Long.MAX_VALUE;
    }

    private double unmakeK(long k) {
        return (double)(-k ^ Long.MAX_VALUE) / 1000.0;
    }

    private long queryK(long k) {
        double sum = 0.0;
        while (k != 0L) {
            sum += this.innerGet(k);
            k -= k & -k;
        }
        return Math.round(sum);
    }

    public double quantile(double value) {
        double target = value * (double)this.total;
        long roundedTarget = Math.max(Math.min(Math.round(target), (long)this.total), 1L);
        if (Math.abs(target - (double)roundedTarget) < 1.0E-6) {
            return (this.lowerBound(roundedTarget) + this.upperBound(roundedTarget)) / 2.0;
        }
        return this.lowerBound(roundedTarget);
    }

    private double lowerBound(long sum) {
        if ((double)Math.abs(this.total) < 1.0E-6) {
            return 0.0;
        }
        long begin = 0L;
        long count = -1L;
        while (count != 0L) {
            long step = count >>> 1;
            long it = begin + step;
            if (this.queryK(it) < sum) {
                begin = it + 1L;
                count -= step + 1L;
                continue;
            }
            count = step;
        }
        return this.unmakeK(begin);
    }

    private double upperBound(double sum) {
        if ((double)Math.abs(this.total) < 1.0E-6) {
            return 0.0;
        }
        long begin = 0L;
        long count = -1L;
        while (count != 0L) {
            long step = count >>> 1;
            long it = begin + step;
            if (!(sum < (double)this.queryK(it))) {
                begin = it + 1L;
                count -= step + 1L;
                continue;
            }
            count = step;
        }
        return this.unmakeK(begin);
    }

    private void innerAdd(long v, double weight) {
        int n = this.hash(v, 0);
        this.M[n] = (int)((double)this.M[n] + weight);
        int n2 = this.width + this.hash(v, 1);
        this.M[n2] = (int)((double)this.M[n2] + weight);
    }

    private double innerGet(long v) {
        return (double)Math.min(this.M[this.hash(v, 0)], this.M[this.width + this.hash(v, 1)]) - this.e * (double)this.total / 2.0;
    }

    private int hash(long v, int i) {
        return MurmurHash.hashLong(v, i) & this.mask;
    }
}

