/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.intelie.pipes.Tree;
import net.intelie.pipes.aggregations.dcount.CreateHLLState;
import net.intelie.pipes.aggregations.similarity.MinHashUnion;
import net.intelie.pipes.util.SafeCloseable;

public class MinHash
implements Tree {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong orderSeq = new AtomicLong(0L);
    private final int[] data;
    private int originalSize;

    public MinHash(int[] data, int originalSize) {
        this.data = data;
        this.originalSize = originalSize;
    }

    public static MinHash copy(int[] data, int size, int originalSize) {
        int[] newData = Arrays.copyOf(data, size);
        Arrays.sort(newData);
        return new MinHash(newData, originalSize);
    }

    public static MinHash copyWithSize(int originalSize, int ... data) {
        return MinHash.copy(data, data.length, originalSize);
    }

    public static MinHash copy(int ... data) {
        return MinHash.copyWithSize(data.length, data);
    }

    public static Double similarity(MinHash ... minHashes) {
        return MinHash.similarity(Arrays.asList(minHashes));
    }

    public static Double similarity(Collection<MinHash> minHashes) {
        List<MinHash> sorted = minHashes.stream().filter(x -> x.size() > 0).sorted(Comparator.comparing(MinHash::first)).collect(Collectors.toList());
        if (sorted.size() == 0) {
            return null;
        }
        MinHashUnion union = new MinHashUnion(sorted);
        try (SafeCloseable ignored = union.init();){
            int b;
            int minLength = minHashes.stream().mapToInt(x -> x.originalSize).min().orElse(0);
            if (minLength == 0) {
                Double d = 0.0;
                return d;
            }
            int a = 0;
            for (b = 0; b < minLength && union.moveNext(); ++b) {
                if (union.count() != minHashes.size()) continue;
                ++a;
            }
            Double d = (double)a / (double)b;
            return d;
        }
    }

    public int[] get() {
        return this.data;
    }

    public int get(int index) {
        return this.data[index];
    }

    public int size() {
        return this.data.length;
    }

    /*
     * Exception decompiling
     */
    public static String toCompressedString(MinHash minHash) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static MinHash fromCompressedString(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int originalSize() {
        return this.originalSize;
    }

    public int first() {
        return this.data.length > 0 ? this.data[0] : Integer.MIN_VALUE;
    }

    public static int hash(Object obj) {
        return CreateHLLState.hashValue(0, obj);
    }
}

