/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.aggregations.similarity.MinHashInsertMerger;

public abstract class MinHashFunctions {
    @Help(key="scalar-minhash-eval")
    @Export(value={"minhash.eval"})
    public static Double minhasheval(String a, String b, String ... ss) {
        MinHash ma = MinHash.fromCompressedString(a);
        MinHash mb = MinHash.fromCompressedString(b);
        if (ma == null || mb == null) {
            return null;
        }
        MinHash[] ms = new MinHash[2 + ss.length];
        ms[0] = ma;
        ms[1] = mb;
        for (int i = 0; i < ss.length; ++i) {
            MinHash m = MinHash.fromCompressedString(ss[i]);
            if (m == null) {
                return null;
            }
            ms[2 + i] = m;
        }
        return MinHash.similarity(ms);
    }

    @Help(key="scalar-minhash-merge")
    @Export(value={"minhash.merge"})
    public static String minhashmerge(String s1, String s2, String ... ss) {
        MinHashInsertMerger merger = new MinHashInsertMerger();
        merger.add(MinHash.fromCompressedString(s1));
        merger.add(MinHash.fromCompressedString(s2));
        for (String s : ss) {
            merger.add(MinHash.fromCompressedString(s));
        }
        return MinHash.toCompressedString(merger.get());
    }
}

