/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.aggregations.similarity.MinHashState;

public class MinHashInsertMerger {
    private MinHashState state = null;
    private int minSize = Integer.MAX_VALUE;

    public void add(MinHash mh) {
        if (mh == null || mh.originalSize() == Integer.MAX_VALUE) {
            return;
        }
        if (this.state == null) {
            this.state = new MinHashState(mh.originalSize());
        }
        this.minSize = Math.min(this.minSize, mh.originalSize());
        this.state.shrink(this.minSize);
        if (this.minSize > 0) {
            for (int e : mh.get()) {
                this.state.add(e);
            }
        }
    }

    public MinHash get() {
        return this.state != null ? this.state.get() : MinHash.copyWithSize(Integer.MAX_VALUE, new int[0]);
    }

    public void clear() {
        this.state = null;
        this.minSize = Integer.MAX_VALUE;
    }
}

