/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.aggregations.similarity.MinHashInsertMerger;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"minhash.merge"})
@Help(key="aggregation-minhash-merge")
public class MinHashMergeAggregation
implements Aggregation<String> {
    private final Scalar<String> expr;

    public MinHashMergeAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.STRING).get();
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public String toString() {
        return "minhash.merge(" + this.expr + ")";
    }

    public String eval(Scope parent, Tree tree, WindowBounds bounds) {
        return MinHash.toCompressedString((MinHash)tree);
    }

    public Type<String> type() {
        return Type.STRING;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 16392L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MinHash> {
        private final MinHashInsertMerger merger = new MinHashInsertMerger();

        private MyInsertMerger() {
        }

        public void pushQ(MinHash tree) {
            this.merger.add(tree);
        }

        public void clear() {
            this.merger.clear();
        }

        public MinHash get() {
            return this.merger.get();
        }
    }

    private class MyState
    implements State {
        private final MinHashInsertMerger state = new MinHashInsertMerger();

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            String s = (String)MinHashMergeAggregation.this.expr.eval(parent, obj);
            this.state.add(MinHash.fromCompressedString(s));
        }

        public Tree flip() {
            MinHash hash = this.state.get();
            this.state.clear();
            return hash;
        }
    }
}

