/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.guava.collect.Ordering;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class MinHashState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeSet<Integer> data = new TreeSet(Ordering.natural().reversed());
    private int originalSize;

    public MinHashState(int size) {
        this.originalSize = size;
    }

    public void clear() {
        this.data.clear();
    }

    public MinHash get() {
        int size = Math.min(this.data.size(), this.originalSize);
        int[] ints = new int[size];
        int i = 0;
        for (Integer value : this.data.descendingSet()) {
            if (i >= ints.length) break;
            ints[i++] = value;
        }
        return new MinHash(ints, this.originalSize);
    }

    public void add(int value) {
        if (this.data.size() < this.originalSize) {
            this.data.add(value);
        } else if (value < (Integer)Iterables.getFirst(this.data, (Object)Integer.MIN_VALUE)) {
            Iterator<Integer> it = this.data.iterator();
            it.next();
            it.remove();
            this.data.add(value);
        }
    }

    public void shrink(int newSize) {
        Preconditions.checkArgument((newSize <= this.originalSize ? 1 : 0) != 0, (Object)"new size must not be larger than current size");
        this.originalSize = newSize;
    }
}

