/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import java.util.Iterator;
import java.util.PriorityQueue;
import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.util.SafeCloseable;

public class MinHashUnion {
    private final Iterable<MinHash> iterable;
    private final PriorityQueue<Slot> queue = new PriorityQueue();
    private Iterator<MinHash> it;
    private int count = 0;
    private int current;
    private int next;
    private boolean eof;
    private MinHash top;

    public MinHashUnion(Iterable<MinHash> iterable) {
        this.iterable = iterable;
        this.it = iterable.iterator();
    }

    public SafeCloseable init() {
        this.it = this.iterable.iterator();
        this.top = this.it.hasNext() ? this.it.next() : null;
        this.eof = false;
        this.weakMoveNext();
        return () -> {
            this.queue.clear();
            this.top = null;
        };
    }

    public boolean moveNext() {
        if (this.eof) {
            return false;
        }
        this.count = 0;
        this.current = this.next;
        while (this.current == this.next) {
            ++this.count;
            if (this.weakMoveNext()) continue;
            this.eof = true;
            break;
        }
        return true;
    }

    private boolean weakMoveNext() {
        if (this.queue.isEmpty() && this.top == null) {
            return false;
        }
        if (this.top != null && (this.queue.isEmpty() || this.top.get(0) < this.queue.peek().value())) {
            this.next = this.top.get(0);
            if (this.top.size() > 1) {
                this.queue.add(new Slot(this.top));
            }
            this.top = this.it.hasNext() ? this.it.next() : null;
        } else {
            Slot slot = this.queue.poll();
            this.next = slot.value();
            slot.increment();
            if (!slot.isEmpty()) {
                this.queue.add(slot);
            }
        }
        return true;
    }

    public int current() {
        return this.current;
    }

    public int count() {
        return this.count;
    }

    private static class Slot
    implements Comparable<Slot> {
        private final MinHash hash;
        private int index;

        private Slot(MinHash hash) {
            this.hash = hash;
            this.index = 1;
        }

        public int value() {
            return this.hash.get(this.index);
        }

        public boolean isEmpty() {
            return this.index >= this.hash.size();
        }

        public boolean increment() {
            ++this.index;
            return !this.isEmpty();
        }

        @Override
        public int compareTo(Slot o) {
            return Integer.compare(this.value(), o.value());
        }
    }
}

