/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.similarity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AutoFullMerger;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.aggregations.similarity.MinHash;
import net.intelie.pipes.aggregations.similarity.MinHashInsertMerger;
import net.intelie.pipes.aggregations.similarity.MinHashState;
import net.intelie.pipes.guava.collect.HashMultiset;
import net.intelie.pipes.guava.collect.Multiset;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"similarity"})
@Help(key="aggregation-similarity")
public class SimilarityAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar[] exprs;
    private final int sz = 4096;
    private final int threshold;

    public SimilarityAggregation(ArgQueue queue) throws PipeException {
        this(1024, queue);
    }

    public SimilarityAggregation(int threshold, ArgQueue queue) throws PipeException {
        this.threshold = threshold;
        this.exprs = (Scalar[])queue.scalar((Type)Type.OBJECT).array();
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (Scalar expr : this.exprs) {
            expr.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    public State newState(int flips) {
        return new MyState(flips);
    }

    public FullMerger newMerger() {
        return new AutoFullMerger(this.newInsertMerger());
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public String toString() {
        return "similarity(" + Iterables.join((String)", ", (Object[])this.exprs) + ")";
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (tree instanceof DeterministicTree) {
            DeterministicTree myTree = (DeterministicTree)tree;
            HashSet union = new HashSet();
            Arrays.stream(myTree.sets).forEach(union::addAll);
            if (union.size() == 0) {
                return null;
            }
            HashSet insersection = new HashSet(myTree.sets[0]);
            for (int i = 1; i < myTree.sets.length; ++i) {
                insersection.retainAll(myTree.sets[i]);
            }
            return (double)insersection.size() / (double)union.size();
        }
        SketchTree myTree = (SketchTree)tree;
        return MinHash.similarity(myTree.minHashes);
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 8 * Math.max(4096, this.threshold);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer((Expression[])this.exprs);
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    private class MyInsertMerger
    extends InsertMerger.Base<Tree> {
        private MinHashInsertMerger[] mergers = null;
        private final Multiset<DeterministicTree> set = HashMultiset.create();

        private MyInsertMerger() {
        }

        private void fillSketch() {
            this.mergers = new MinHashInsertMerger[SimilarityAggregation.this.exprs.length];
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                this.mergers[i] = new MinHashInsertMerger();
            }
            for (DeterministicTree tree : this.set) {
                this.addDetTree(tree);
            }
            this.set.clear();
        }

        public void clear() {
            this.mergers = null;
            this.set.clear();
        }

        private void addDetTree(DeterministicTree tree) {
            MinHashState state = new MinHashState(4096);
            MinHash[] hashes = new MinHash[SimilarityAggregation.this.exprs.length];
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                state.clear();
                for (Object o : tree.sets[i]) {
                    state.add(MinHash.hash(o));
                }
                hashes[i] = state.get();
                this.mergers[i].add(hashes[i]);
            }
        }

        public void pushQ(Tree tree) {
            if (tree instanceof DeterministicTree) {
                DeterministicTree myTree = (DeterministicTree)tree;
                if (this.mergers != null) {
                    this.addDetTree(myTree);
                } else {
                    this.set.add(myTree);
                }
            } else {
                SketchTree myTree = (SketchTree)tree;
                if (this.mergers == null) {
                    this.fillSketch();
                }
                MinHash[] minHashes = myTree.minHashes;
                for (int i = 0; i < minHashes.length; ++i) {
                    this.mergers[i].add(minHashes[i]);
                }
            }
        }

        public Tree get() {
            if (this.mergers != null) {
                MinHash[] hashes = new MinHash[SimilarityAggregation.this.exprs.length];
                for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                    hashes[i] = this.mergers[i].get();
                }
                return new SketchTree(hashes);
            }
            HashSet[] finalSets = new HashSet[SimilarityAggregation.this.exprs.length];
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                finalSets[i] = new HashSet();
            }
            for (DeterministicTree tree : this.set) {
                for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                    finalSets[i].addAll(tree.sets[i]);
                }
            }
            return new DeterministicTree(finalSets);
        }
    }

    private static class SketchTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final MinHash[] minHashes;

        public SketchTree(MinHash[] minHashes) {
            this.minHashes = minHashes;
        }
    }

    private static class DeterministicTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Set<Object>[] sets;

        public DeterministicTree(Set<Object>[] sets) {
            this.sets = sets;
        }
    }

    private class MyState
    implements State {
        private MinHashState[] states;
        private Set<Object>[] sets;
        private int total;

        public MyState(int flips) {
            this.sets = new Set[SimilarityAggregation.this.exprs.length];
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                this.sets[i] = new HashSet<Object>();
            }
        }

        private void fillSketch() {
            this.states = new MinHashState[SimilarityAggregation.this.exprs.length];
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                this.states[i] = new MinHashState(4096);
                for (Object e : this.sets[i]) {
                    this.states[i].add(MinHash.hash(e));
                }
                this.sets[i] = new HashSet<Object>();
            }
            this.total = 0;
        }

        private void clear() {
            this.states = null;
            this.total = 0;
            for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                this.sets[i] = new HashSet<Object>();
            }
        }

        public void yield(Scope parent, Object obj) {
            if (this.states != null) {
                for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                    this.states[i].add(MinHash.hash(SimilarityAggregation.this.exprs[i].eval(parent, obj)));
                }
            } else {
                for (int i = 0; i < SimilarityAggregation.this.exprs.length; ++i) {
                    if (!this.sets[i].add(SimilarityAggregation.this.exprs[i].eval(parent, obj))) continue;
                    ++this.total;
                }
                if (this.total >= SimilarityAggregation.this.threshold) {
                    this.fillSketch();
                }
            }
        }

        public Tree flip() {
            Object tree = this.states != null ? new SketchTree((MinHash[])Arrays.stream(this.states).map(MinHashState::get).toArray(MinHash[]::new)) : new DeterministicTree((Set[])Arrays.stream(this.sets).map(HashSet::new).toArray(Set[]::new));
            this.clear();
            return tree;
        }
    }
}

