/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.unsafe;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public abstract class CollectionAggregation
implements Aggregation<Iterable> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Object> key;
    private final SeqType type;

    public CollectionAggregation(ArgQueue queue) throws PipeException {
        this.key = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        this.type = new SeqType(this.key.type());
    }

    public abstract String name();

    public abstract Collection makeCollection();

    public String toString() {
        return this.name() + "(" + this.key + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public Type<Iterable> type() {
        return this.type;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 32768L;
    }

    public Iterable eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ((MyTree)tree).value;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.key.visit(parent, visitor);
        return visitor.newScope();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.key});
    }

    private class MyState
    implements State {
        private volatile Collection value;

        private MyState() {
            this.value = CollectionAggregation.this.makeCollection();
        }

        public void yield(Scope parent, Object obj) {
            this.value.add(CollectionAggregation.this.key.eval(parent, obj));
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.value);
            this.value = CollectionAggregation.this.makeCollection();
            return tree;
        }
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private final Set<MyTree> value = new LinkedHashSet<MyTree>();

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            this.value.add(tree);
        }

        public void removeQ(MyTree tree) {
            this.value.remove(tree);
        }

        public void clear() {
            this.value.clear();
        }

        public MyTree get() {
            Collection map = CollectionAggregation.this.makeCollection();
            for (MyTree tree : this.value) {
                map.addAll(tree.value);
            }
            return new MyTree(map);
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Collection value;

        public MyTree(Collection value) {
            this.value = value;
        }
    }
}

