/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.unsafe;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LongQueue;

@Export(value={"map"})
@Help(key="aggregation-map")
public class MapAggregation
implements Aggregation<Map> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Object> key;
    private final Aggregation<Object> value;
    private final MapType type;

    public MapAggregation(ArgQueue queue) throws PipeException {
        this.key = (Scalar)queue.scalar((Type)Type.OBJECT).get();
        this.value = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
        this.type = new MapType(this.key.type(), this.value.type());
    }

    public String toString() {
        return "map(" + this.key + ", " + this.value + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new MyFullMerger();
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public Type<Map> type() {
        return this.type;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 40960L;
    }

    public Map eval(Scope parent, Tree tree, WindowBounds bounds) {
        LinkedHashMap map = new LinkedHashMap();
        ((MyTree)tree).value.entrySet().stream().forEach(x -> map.put(x.getKey(), this.value.eval(parent, (Tree)x.getValue(), bounds)));
        return map;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.key.visit(parent, visitor);
        this.value.visit(parent, visitor);
        return visitor.newScope();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.key, this.value});
    }

    private class MyState
    implements State {
        private volatile Map<Object, State> map = new LinkedHashMap<Object, State>();

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            State state = this.map.computeIfAbsent(MapAggregation.this.key.eval(parent, obj), x -> MapAggregation.this.value.newState(0));
            state.yield(parent, obj);
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((State)x.getValue()).flip())));
            this.map.clear();
            return tree;
        }
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MyTree> {
        private final Map<Object, InsertMerger> map = new LinkedHashMap<Object, InsertMerger>();

        private MyInsertMerger() {
        }

        public void pushQ(MyTree tree) {
            for (Map.Entry entry : tree.value.entrySet()) {
                this.map.computeIfAbsent(entry.getKey(), x -> MapAggregation.this.value.newInsertMerger()).push((Tree)entry.getValue());
            }
        }

        public void clear() {
            this.map.clear();
        }

        public MyTree get() {
            return new MyTree(this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((InsertMerger)x.getValue()).get())));
        }
    }

    private class MyFullMerger
    extends FullMerger.Base<MyTree> {
        private final Map<Object, InnerMerger> map = new LinkedHashMap<Object, InnerMerger>();
        private long push = 0L;
        private long pop = 0L;

        private MyFullMerger() {
        }

        public void pushQ(MyTree tree) {
            ++this.push;
            for (Map.Entry entry : tree.value.entrySet()) {
                this.map.computeIfAbsent(entry.getKey(), x -> new InnerMerger()).push((Tree)entry.getValue());
            }
        }

        public void pop() {
            ++this.pop;
            this.map.entrySet().removeIf(x -> ((InnerMerger)x.getValue()).maybePop(this.pop));
        }

        public void clear() {
            this.pop = 0L;
            this.push = 0L;
            this.map.clear();
        }

        public MyTree get() {
            return new MyTree(this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((InnerMerger)x.getValue()).get())));
        }

        private class InnerMerger {
            private final FullMerger merger;
            private final LongQueue queue;

            private InnerMerger() {
                this.merger = MapAggregation.this.value.newMerger();
                this.queue = new LongQueue();
            }

            public boolean maybePop(long thisPop) {
                if (thisPop < this.queue.peek()) {
                    return false;
                }
                this.merger.pop();
                this.queue.dequeue();
                return this.queue.isEmpty();
            }

            public void push(Tree tree) {
                this.merger.push(tree);
                this.queue.enqueue(MyFullMerger.this.push);
            }

            public Tree get() {
                return this.merger.get();
            }
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Map<Object, Tree> value;

        public MyTree(Map<Object, Tree> value) {
            this.value = value;
        }
    }
}

