/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations.unsafe;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToLiteral;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"summary"})
@Help(key="aggregation-summary")
public class SummaryAggregation
implements Aggregation<String> {
    private static final long serialVersionUID = 1L;
    private final Scalar<String> expr;
    private final Aggregation<String> separator;
    private final Aggregation<String> lastSeparator;

    public SummaryAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.STRING).get();
        this.separator = (Aggregation)queue.aggregation((Type)Type.STRING).getOptional(new FallbackToLiteral(Type.STRING, ", "));
        this.lastSeparator = (Aggregation)queue.aggregation((Type)Type.STRING).getOptional();
    }

    public String toString() {
        if (this.lastSeparator != null) {
            return "summary(" + this.expr + ", " + this.separator + ", " + this.lastSeparator + ")";
        }
        return "summary(" + this.expr + ", " + this.separator + ")";
    }

    public State newState(int flips) {
        return new MyState(this.separator.newState(flips), this.lastSeparator != null ? this.lastSeparator.newState(flips) : null);
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public Type<String> type() {
        return Type.STRING;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 40960L + this.separator.weight() + (this.lastSeparator != null ? this.lastSeparator.weight() : 0L);
    }

    public String eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree my = (MyTree)tree;
        String separatorStr = (String)this.separator.eval(parent, my.separatorTree, bounds);
        String lastSeparatorStr = this.lastSeparator != null ? (String)this.lastSeparator.eval(parent, my.lastSeparatorTree, bounds) : separatorStr;
        StringBuilder builder = new StringBuilder();
        List value = my.value;
        for (int i = 0; i < value.size(); ++i) {
            if (i > 0) {
                if (i + 1 < value.size()) {
                    builder.append(separatorStr);
                } else {
                    builder.append(lastSeparatorStr);
                }
            }
            builder.append((String)value.get(i));
        }
        return builder.toString();
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        this.separator.visit(parent, visitor);
        if (this.lastSeparator != null) {
            this.lastSeparator.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr, this.separator, this.lastSeparator});
    }

    static /* synthetic */ Aggregation access$500(SummaryAggregation x0) {
        return x0.separator;
    }

    private class MyState
    implements State {
        private final State separator;
        private final State lastSeparator;
        private volatile List<String> list = new LinkedList<String>();

        private MyState(State separator, State lastSeparator) {
            this.separator = separator;
            this.lastSeparator = lastSeparator;
        }

        public void yield(Scope parent, Object obj) {
            this.list.add((String)SummaryAggregation.this.expr.eval(parent, obj));
            this.separator.yield(parent, obj);
            if (this.lastSeparator != null) {
                this.lastSeparator.yield(parent, obj);
            }
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.list, this.separator.flip(), this.lastSeparator != null ? this.lastSeparator.flip() : null);
            this.list = new LinkedList<String>();
            return tree;
        }
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private final Set<MyTree> set = new LinkedHashSet<MyTree>();
        private final FullMerger separatorMerger = SummaryAggregation.access$500(SummaryAggregation.this).newMerger();
        private final FullMerger lastSeparatorMerger = SummaryAggregation.access$600(SummaryAggregation.this) != null ? SummaryAggregation.access$600(SummaryAggregation.this).newMerger() : null;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            this.set.add(tree);
            this.separatorMerger.push(tree.separatorTree);
            if (SummaryAggregation.this.lastSeparator != null) {
                this.lastSeparatorMerger.push(tree.lastSeparatorTree);
            }
        }

        public void removeQ(MyTree tree) {
            this.set.remove(tree);
            this.separatorMerger.pop();
            if (SummaryAggregation.this.lastSeparator != null) {
                this.lastSeparatorMerger.pop();
            }
        }

        public void clear() {
            this.set.clear();
            this.separatorMerger.clear();
            if (SummaryAggregation.this.lastSeparator != null) {
                this.lastSeparatorMerger.clear();
            }
        }

        public MyTree get() {
            LinkedList<String> list = new LinkedList<String>();
            for (MyTree tree : this.set) {
                list.addAll(tree.value);
            }
            return new MyTree(list, this.separatorMerger.get(), SummaryAggregation.this.lastSeparator != null ? this.lastSeparatorMerger.get() : null);
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final List<String> value;
        private final Tree separatorTree;
        private final Tree lastSeparatorTree;

        public MyTree(List<String> value, Tree separatorTree, Tree lastSeparatorTree) {
            this.value = value;
            this.separatorTree = separatorTree;
            this.lastSeparatorTree = lastSeparatorTree;
        }
    }
}

