/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.filters.FinalAutomaton;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Preconditions;

public class BuildingAutomaton {
    private final Type type;
    private final List<State> states;

    public BuildingAutomaton() {
        this((Type)Type.STRING);
    }

    public BuildingAutomaton(Type type) {
        this(type, BuildingAutomaton.makeInitial());
    }

    private static List<State> makeInitial() {
        ArrayList<State> list = new ArrayList<State>();
        list.add(new State());
        return list;
    }

    private BuildingAutomaton(Type type, List<State> list) {
        this.type = type;
        this.states = list;
    }

    public Type type() {
        return this.type;
    }

    public FinalAutomaton freeze() {
        int totalNext = 0;
        int totalProduces = 0;
        for (State state : this.states) {
            totalNext += state.transitions.size();
            totalProduces += state.produces.size();
        }
        int size = this.states.size();
        int[] nStart = new int[size];
        int[] nSize = new int[size];
        int[] pStart = new int[size];
        int[] pSize = new int[size];
        int[] produces = new int[totalProduces];
        long[] next = new long[totalNext];
        for (int i = 0; i < size; ++i) {
            int j;
            State state = this.states.get(i);
            nStart[i] = i > 0 ? nStart[i - 1] + nSize[i - 1] : 0;
            pStart[i] = i > 0 ? pStart[i - 1] + pSize[i - 1] : 0;
            nSize[i] = state.transitions.size();
            pSize[i] = state.produces.size();
            for (j = 0; j < state.transitions.size(); ++j) {
                next[nStart[i] + j] = ((Transition)state.transitions.get(j)).toLong();
            }
            for (j = 0; j < state.produces.size(); ++j) {
                produces[pStart[i] + j] = (Integer)state.produces.get(j);
            }
        }
        return new FinalAutomaton(this.type, produces, next, nStart, nSize, pStart, pSize);
    }

    public BuildingAutomaton merge(BuildingAutomaton other, int offset) {
        BuildingAutomaton impl = other;
        Preconditions.checkArgument((boolean)impl.type.equals((Object)this.type), (String)"invalid merging type: %s", (Object[])new Object[]{impl.type});
        HashMap<Integer, Integer> converted = new HashMap<Integer, Integer>();
        this.merge(0, impl, 0, offset, converted);
        return this;
    }

    private void merge(int toState, BuildingAutomaton other, int fromState, int offset, Map<Integer, Integer> converted) {
        if (converted.containsKey(fromState)) {
            return;
        }
        converted.put(fromState, toState);
        State to = this.states.get(toState);
        State from = other.states.get(fromState);
        for (Integer produce : from.produces) {
            to.produces(produce + offset);
        }
        for (int i = 0; i < from.transitions.size(); ++i) {
            Transition fromTrans = (Transition)from.transitions.get(i);
            boolean found = false;
            for (int j = 0; j < to.transitions.size(); ++j) {
                Transition toTrans = (Transition)to.transitions.get(j);
                if (!fromTrans.matches(toTrans)) continue;
                this.merge(toTrans.next, other, fromTrans.next, offset, converted);
                found = true;
                break;
            }
            if (found) continue;
            int oldNext = fromTrans.next;
            Integer newNext = converted.get(oldNext);
            if (newNext == null) {
                newNext = this.add(new State());
            }
            to.toRaw(newNext, fromTrans);
            this.merge(newNext, other, oldNext, offset, converted);
        }
    }

    private State last() {
        return this.states.get(this.lastIdx());
    }

    private int lastIdx() {
        return this.states.size() - 1;
    }

    private int add(State state) {
        this.states.add(state);
        return this.states.size() - 1;
    }

    public BuildingAutomaton copy() {
        ArrayList<State> states = new ArrayList<State>();
        for (State state : this.states) {
            states.add(state.copy());
        }
        return new BuildingAutomaton(this.type, states);
    }

    private static class State {
        private final List<Integer> produces = new ArrayList<Integer>();
        private final List<Transition> transitions = new ArrayList<Transition>();

        private State() {
        }

        public int produces(int value) {
            this.produces.add(value);
            return this.produces.size() - 1;
        }

        public int to(int state, int exact, List id) {
            return this.toRange(state, exact, exact, id);
        }

        public int toRange(int state, int lo, int hi, List id) {
            return this.add(new Transition(true, state, lo, hi, id));
        }

        public int toRaw(int state, Transition raw) {
            return this.add(new Transition(raw.consumes, state, raw.lo, raw.hi, raw.identifier));
        }

        public int toAny(int state, List id) {
            return this.add(new Transition(true, state, 0, -1, id));
        }

        public int toNonConsuming(int state, List id) {
            return this.add(new Transition(false, state, 0, 0, id));
        }

        private int add(Transition transition) {
            this.transitions.add(transition);
            return this.transitions.size() - 1;
        }

        public State copy() {
            State copy = new State();
            copy.produces.addAll(this.produces);
            copy.transitions.addAll(this.transitions);
            return copy;
        }
    }

    private static class Transition {
        private final boolean consumes;
        private final int next;
        private final int hi;
        private final int lo;
        private final List identifier;

        public Transition(boolean consumes, int next, int lo, int hi, List identifier) {
            this.consumes = consumes;
            this.next = next;
            this.lo = lo;
            this.hi = hi;
            this.identifier = identifier;
        }

        public boolean matches(Transition other) {
            return this.consumes == other.consumes && this.hi == other.hi && this.lo == other.lo && Objects.equals(this.identifier, other.identifier);
        }

        public long toLong() {
            long value = 0L;
            if (this.consumes) {
                value |= Long.MIN_VALUE;
            }
            value |= (long)this.next << 32 & 0x7FFFFFFF00000000L;
            value |= (long)this.hi << 16 & 0xFFFF0000L;
            return value |= (long)this.lo & 0xFFFFL;
        }
    }

    public static class Builder {
        private final BuildingAutomaton auto;
        private final Type type;

        public Builder() {
            this((Type)Type.STRING);
        }

        public Builder(Type type) {
            this.type = type;
            this.auto = new BuildingAutomaton(type);
        }

        public Builder literal(Object s) {
            BinaryIterator it = this.makeIterator(s);
            if (it == null) {
                return this;
            }
            while (it.moveNext()) {
                this.auto.last().to(this.auto.add(new State()), it.current(), null);
            }
            return this;
        }

        private BinaryIterator makeIterator(Object s) {
            BinaryIterator it = this.type.newIterator();
            if (!it.reset(s)) {
                return null;
            }
            return it;
        }

        public Builder fuzzy(Object s, int edits) {
            BinaryIterator it = this.makeIterator(s);
            if (it == null) {
                return this;
            }
            int[] P = new int[++edits];
            int[] Q = new int[edits];
            P[0] = this.auto.lastIdx();
            for (int i = 1; i < edits; ++i) {
                P[i] = this.auto.add(new State());
                ((State)this.auto.states.get(P[i - 1])).toAny(P[i], Arrays.asList("fuzzy1"));
            }
            while (it.moveNext()) {
                int c = it.current();
                int state = Q[0] = this.auto.add(new State());
                ((State)this.auto.states.get(P[0])).to(state, c, null);
                for (int j = 1; j < edits; ++j) {
                    Q[j] = this.auto.add(new State());
                    ((State)this.auto.states.get(Q[j - 1])).toAny(Q[j], Arrays.asList("fuzzy1"));
                    ((State)this.auto.states.get(P[j])).to(Q[j], c, null);
                    ((State)this.auto.states.get(P[j - 1])).toNonConsuming(Q[j], Arrays.asList("fuzzy2"));
                    ((State)this.auto.states.get(P[j - 1])).toAny(Q[j], Arrays.asList("fuzzy3"));
                }
                int[] T = Q;
                Q = P;
                P = T;
            }
            int join = this.auto.add(new State());
            for (int i = 0; i < edits; ++i) {
                ((State)this.auto.states.get(P[i])).toNonConsuming(join, Arrays.asList("fuzzy", s, edits));
            }
            return this;
        }

        public Builder range(Object a, Object b, boolean includeA, boolean includeB) {
            int cb;
            BinaryIterator ita = this.makeIterator(a);
            BinaryIterator itb = this.makeIterator(b);
            int state = this.auto.lastIdx();
            boolean hasA = ita != null;
            boolean hasB = itb != null;
            boolean moreA = hasA && ita.moveNext();
            boolean moreB = hasB && itb.moveNext();
            ArrayList<Integer> toLink = new ArrayList<Integer>();
            while (moreA && moreB && ita.current() == itb.current()) {
                int newState = this.auto.add(new State());
                ((State)this.auto.states.get(state)).to(newState, ita.current(), null);
                state = newState;
                moreA = ita.moveNext();
                moreB = itb.moveNext();
            }
            if (hasA && hasB && !moreA && !moreB && includeA && includeB) {
                return this;
            }
            if (hasB && !moreB) {
                this.auto.add(new State());
                return this;
            }
            int ca = moreA ? ita.current() : -1;
            int n = cb = moreB ? itb.current() : 65536;
            if (ca >= 0) {
                int stateA = this.auto.add(new State());
                ((State)this.auto.states.get(state)).to(stateA, ca, null);
                while (ita.moveNext()) {
                    int newStateA = this.auto.add(new State());
                    int nca = ita.current();
                    ((State)this.auto.states.get(stateA)).to(newStateA, nca, null);
                    if (nca < 65535) {
                        ((State)this.auto.states.get(stateA)).toRange(this.hardMulti(toLink), nca + 1, Integer.MAX_VALUE, null);
                    }
                    stateA = newStateA;
                }
                if (includeA) {
                    this.softMulti(toLink, stateA);
                } else {
                    ((State)this.auto.states.get(stateA)).toAny(this.hardMulti(toLink), null);
                }
            } else {
                toLink.add(state);
            }
            if (ca + 1 <= cb - 1) {
                ((State)this.auto.states.get(state)).toRange(this.hardMulti(toLink), ca + 1, cb - 1, null);
            }
            if (cb <= 65535) {
                int stateB = this.auto.add(new State());
                ((State)this.auto.states.get(state)).to(stateB, cb, null);
                while (itb.moveNext()) {
                    int newStateB = this.auto.add(new State());
                    int ncb = itb.current();
                    ((State)this.auto.states.get(stateB)).to(newStateB, ncb, null);
                    toLink.add(stateB);
                    if (ncb > 0) {
                        ((State)this.auto.states.get(stateB)).toRange(this.hardMulti(toLink), 0, ncb - 1, null);
                    }
                    stateB = newStateB;
                }
                if (includeB) {
                    toLink.add(stateB);
                }
            }
            int rendezvous = this.auto.add(new State());
            for (Integer link : toLink) {
                ((State)this.auto.states.get(link)).toNonConsuming(rendezvous, Arrays.asList("range", a, b, includeA, includeB));
            }
            return this;
        }

        private int hardMulti(List<Integer> toLink) {
            int pre = this.auto.add(new State());
            int multi = this.auto.add(new State());
            ((State)this.auto.states.get(multi)).toAny(multi, null);
            ((State)this.auto.states.get(pre)).toNonConsuming(multi, Arrays.asList("zeroOrMore"));
            toLink.add(multi);
            return pre;
        }

        private int softMulti(List<Integer> toLink, int fromState) {
            int multi = this.auto.add(new State());
            ((State)this.auto.states.get(multi)).toAny(multi, null);
            ((State)this.auto.states.get(fromState)).toNonConsuming(multi, Arrays.asList("zeroOrMore"));
            toLink.add(multi);
            return multi;
        }

        public Builder zeroOrMore() {
            this.auto.last().toNonConsuming(this.auto.add(new State()), Arrays.asList("zeroOrMore"));
            this.auto.last().toAny(this.auto.lastIdx(), null);
            return this;
        }

        public Builder any() {
            this.auto.last().toAny(this.auto.add(new State()), null);
            return this;
        }

        public BuildingAutomaton build(int produce) {
            BuildingAutomaton copy = this.auto.copy();
            copy.last().produces(produce);
            return copy;
        }
    }
}

