/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterOptimizer;
import net.intelie.pipes.filters.FilterVisitor;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.Segment;
import net.intelie.pipes.filters.SegmentsTester;
import net.intelie.pipes.filters.TermFilter;

public class DependencyChecker
extends FilterVisitor<Map<String, Filter>> {
    private final PropertyGroup property;
    private final Collection<String> types;

    public DependencyChecker(PropertyGroup property) {
        this(property, null);
    }

    public DependencyChecker(PropertyGroup property, Collection<String> types) {
        this.property = property;
        this.types = types;
    }

    public DependencyChecker withTypes(Collection<String> types) {
        return new DependencyChecker(this.property, types);
    }

    public Map<String, Filter> visit(Filter filter) throws PipeException {
        LinkedHashMap<String, Filter> result = new LinkedHashMap<String, Filter>();
        for (Map.Entry entry : ((Map)super.visit(filter)).entrySet()) {
            Filter optimized = FilterOptimizer.optimize((Filter)((Filter)entry.getValue()));
            if (entry.getKey() == null && OrFilter.isNone((Filter)optimized)) continue;
            result.put((String)entry.getKey(), optimized);
        }
        return result;
    }

    public Map<String, Filter> visitNot(NotFilter filter) throws PipeException {
        LinkedHashMap<String, Filter> result = new LinkedHashMap<String, Filter>();
        for (Map.Entry entry : this.visit(filter.filter()).entrySet()) {
            result.put((String)entry.getKey(), (Filter)new NotFilter((Filter)entry.getValue()));
        }
        if (this.types != null) {
            for (String type : this.types) {
                if (result.containsKey(type = this.normalize(type))) continue;
                result.put(type, (Filter)new AndFilter(new Filter[0]));
            }
        }
        if (!result.containsKey(null)) {
            result.put(null, (Filter)new AndFilter(new Filter[0]));
        }
        return result;
    }

    public Map<String, Filter> visitOr(OrFilter filter) throws PipeException {
        LinkedHashMap<String, Filter> result = new LinkedHashMap<String, Filter>();
        for (Map.Entry<String, List<Filter>> entry : this.makeList(filter.filters()).entrySet()) {
            result.put(entry.getKey(), (Filter)new OrFilter(entry.getValue()));
        }
        return result;
    }

    public Map<String, Filter> visitAnd(AndFilter filter) throws PipeException {
        LinkedHashMap<String, Filter> result = new LinkedHashMap<String, Filter>();
        for (Map.Entry<String, List<Filter>> entry : this.makeList(filter.filters()).entrySet()) {
            result.put(entry.getKey(), (Filter)new AndFilter(entry.getValue()));
        }
        if (result.size() == 0) {
            return this.simpleMap(null, (Filter)new AndFilter(new Filter[0]));
        }
        return result;
    }

    private Map<String, List<Filter>> makeList(List<Filter> filters) throws PipeException {
        LinkedHashMap<String, List<Filter>> result = new LinkedHashMap<String, List<Filter>>();
        List list = this.visitList(filters);
        for (Map map : list) {
            for (String key : map.keySet()) {
                if (result.containsKey(key)) continue;
                result.put(key, new ArrayList());
            }
        }
        for (Map other : list) {
            for (String key : result.keySet()) {
                Filter filter = (Filter)other.get(key);
                if (filter == null) {
                    filter = (Filter)other.get(null);
                }
                if (filter == null) {
                    filter = new OrFilter(new Filter[0]);
                }
                ((List)result.get(key)).add(filter);
            }
        }
        return result;
    }

    public Map<String, Filter> visitAutomaton(TermFilter filter) throws PipeException {
        if (this.property.equals((Object)filter.property())) {
            String value = DependencyChecker.asSingleString(filter);
            if (value == null) {
                if (this.types != null) {
                    return this.segmentMap(filter.segments(), (Filter)new AndFilter(new Filter[0]));
                }
                return this.simpleMap(null, (Filter)filter);
            }
            return this.simpleMap(value, (Filter)new AndFilter(new Filter[0]));
        }
        return this.simpleMap(null, (Filter)filter);
    }

    private static String asSingleString(TermFilter filter) throws PipeException {
        List segments = filter.segments();
        StringBuilder builder = new StringBuilder();
        for (Segment segment : segments) {
            if (!(segment instanceof Segment.Literal)) {
                return null;
            }
            builder.append(((Segment.Literal)segment).value());
        }
        return builder.toString();
    }

    private Map<String, Filter> simpleMap(String value, Filter filter) {
        LinkedHashMap<String, Filter> map = new LinkedHashMap<String, Filter>();
        if (value == null && this.types != null) {
            for (String type : this.types) {
                map.put(this.normalize(type), filter);
            }
        }
        map.put(this.normalize(value), filter);
        return map;
    }

    private String normalize(String value) {
        return value != null ? value.toLowerCase(Locale.ROOT) : null;
    }

    private Map<String, Filter> segmentMap(Iterable<Segment> segments, Filter filter) {
        SegmentsTester tester = new SegmentsTester(segments, this.property.type());
        LinkedHashMap<String, Filter> map = new LinkedHashMap<String, Filter>();
        for (String type : this.types) {
            if (!tester.accepts(type)) continue;
            map.put(this.normalize(type), filter);
        }
        return map;
    }
}

