/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.filters.BuildingAutomata;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterListener;
import net.intelie.pipes.filters.FilterRegistrar;
import net.intelie.pipes.filters.FinalAutomata;
import net.intelie.pipes.filters.LocalListeners;
import net.intelie.pipes.filters.LocalListenersImpl;
import net.intelie.pipes.filters.ObjectSink;

public class FastFilterRuntime {
    private final FilterRegistrar registrar = new FilterRegistrar();
    private final List<FilterPair> pairs = new ArrayList<FilterPair>();
    private FinalAutomata.Instance instance;
    private Object last;

    public void add(Filter filter, ObjectSink sink) {
        this.pairs.add(new FilterPair(filter, sink));
    }

    public void update() {
        BuildingAutomata building = new BuildingAutomata();
        LocalListenersImpl localState = new LocalListenersImpl();
        for (FilterPair pair : this.pairs) {
            pair.register(building);
            pair.register(localState);
        }
        this.instance = building.freeze().newInstance(localState);
    }

    public void flow(Object obj) {
        this.last = obj;
        try {
            if (this.instance != null) {
                this.instance.flow(obj);
            }
        }
        finally {
            this.last = null;
        }
    }

    private class FilterPair {
        private final Filter filter;
        private final ObjectSink sink;

        public FilterPair(Filter filter, ObjectSink sink) {
            this.filter = filter;
            this.sink = sink;
        }

        public void register(BuildingAutomata automata) {
            FastFilterRuntime.this.registrar.register(this.filter, automata);
        }

        public void register(LocalListeners listeners) {
            FastFilterRuntime.this.registrar.register(this.filter, listeners, new FilterListener(){

                @Override
                public void onMatch(long run, boolean value) {
                    if (value) {
                        FilterPair.this.sink.onSingle(FastFilterRuntime.this.last);
                    }
                }
            });
        }
    }
}

