/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FilterContext;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.IsFilter;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterOptimizer;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.Segment;
import net.intelie.pipes.filters.TermFilter;
import net.intelie.pipes.guava.collect.Sets;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConstantHelper;
import net.intelie.pipes.util.Iterables;

public class FilterModule
implements Module {
    private static final long serialVersionUID = 1L;

    public Iterable<Function> functions() {
        return Arrays.asList(new Literal(), new Star(), new Question(), new Range(), new Fuzzy(), new And(), new Or(), new Not(), new Term(), new Property(), new Context(), new Top());
    }

    public String toString() {
        return "filter functions";
    }

    private static class Top
    extends Base {
        private static final long serialVersionUID = 1L;

        private Top() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            FilterContext filterContext = queue.context().filterContext();
            if (filterContext == null) {
                filterContext = new FilterContext(true, (Iterable)queue.context().defaultProperties());
            }
            return FilterOptimizer.optimize((Filter)((Filter)queue.withContext(queue.context().insideFilter(filterContext)).get(Filter.class)));
        }

        public String name() {
            return ".f.top";
        }
    }

    private static class Context
    extends Base {
        private static final long serialVersionUID = 1L;

        private Context() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            PropertyGroup prop = (PropertyGroup)queue.get(PropertyGroup.class);
            return queue.withContext(queue.context().insideFilter(new FilterContext(false, Collections.singletonList(prop)))).get();
        }

        public String name() {
            return ".f.ctx";
        }
    }

    private static class Property
    extends Base {
        private static final long serialVersionUID = 1L;

        private Property() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            ArrayList<String> props = new ArrayList<String>();
            Type type = null;
            while (queue.hasNext()) {
                Object prop = queue.constantValue((Type)Type.OBJECT).getOptional();
                if (prop instanceof String) {
                    props.add((String)prop);
                    continue;
                }
                type = (Type)prop;
                break;
            }
            return new PropertyGroup((PropertySource)queue.context(), type, props);
        }

        public String name() {
            return ".f.prop";
        }
    }

    private static class Term
    extends Base {
        private static final long serialVersionUID = 1L;

        private Term() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            List<Set<? extends Segment>> newSegments;
            Object[] segments = queue.array(Object.class);
            if (segments.length == 1 && segments[0] instanceof Filter) {
                return segments[0];
            }
            FilterContext context = this.getContext(queue);
            if (this.isStarOnly(context, newSegments = this.expandSegments(segments))) {
                return new AndFilter(new Filter[0]);
            }
            PipeException.check((!Iterables.isEmpty((Iterable)context.properties()) ? 1 : 0) != 0, (String)"There are no default fields defined, cannot add query: %s", (Object[])new Object[]{Iterables.join((String)"+", (Object[])queue.copy().array(AstNode.class))});
            ArrayList<Filter> list = new ArrayList<Filter>();
            this.backtrack(context, newSegments, 0, new ArrayDeque<Segment>(), list);
            if (list.size() == 1) {
                return list.get(0);
            }
            return new OrFilter(list);
        }

        private List<Set<? extends Segment>> expandSegments(Object[] segments) throws PipeException {
            ArrayList<Set<? extends Segment>> newSegments = new ArrayList<Set<? extends Segment>>();
            for (Object segment : segments) {
                newSegments.add(Term.makeSegments(segment));
            }
            return newSegments;
        }

        private void backtrack(FilterContext context, List<Set<? extends Segment>> segments, int index, Deque<Segment> temp, List<Filter> filters) throws PipeException {
            if (index >= segments.size()) {
                ArrayList<Segment> copy = new ArrayList<Segment>(temp);
                for (PropertyGroup property : context.properties()) {
                    filters.add((Filter)new TermFilter(property, copy));
                }
                return;
            }
            for (Segment segment : segments.get(index)) {
                temp.addLast(segment);
                this.backtrack(context, segments, index + 1, temp, filters);
                temp.removeLast();
            }
        }

        private boolean isStarOnly(FilterContext context, List<Set<? extends Segment>> segments) throws PipeException {
            if (!context.top()) {
                return false;
            }
            for (Set<? extends Segment> single : segments) {
                if (single.size() == 1 && Segment.Star.isStarOnly((Segment[])new Segment[]{(Segment)Iterables.getFirst(single, null)})) continue;
                return false;
            }
            return true;
        }

        private static Set<? extends Segment> makeSegments(Object segment) throws PipeException {
            if (segment instanceof Segment) {
                return Collections.singleton((Segment)segment);
            }
            return Sets.newLinkedHashSet((Iterable)segment);
        }

        private FilterContext getContext(ArgQueue queue) throws PipeException {
            FilterContext context = queue.context().filterContext();
            PipeException.check((context != null ? 1 : 0) != 0, (String)"Must be inside filter to call '%s'", (Object[])new Object[]{".f.term"});
            return context;
        }

        public String name() {
            return ".f.term";
        }
    }

    private static class Question
    extends Base {
        private static final long serialVersionUID = 1L;

        private Question() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            return Collections.singletonList(new Segment.Question());
        }

        public String name() {
            return ".f.question";
        }
    }

    private static class Star
    extends Base {
        private static final long serialVersionUID = 1L;

        private Star() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            return Collections.singletonList(new Segment.Star());
        }

        public String name() {
            return ".f.star";
        }
    }

    private static class Range
    extends Base {
        private static final long serialVersionUID = 1L;

        private Range() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            Object lower = queue.constantValue((Type)Type.OBJECT).getOptional();
            Object upper = queue.constantValue((Type)Type.OBJECT).getOptional();
            boolean includeLower = (Boolean)queue.constantValue((Type)Type.BOOLEAN).get();
            boolean includeUpper = (Boolean)queue.constantValue((Type)Type.BOOLEAN).get();
            Set<Object> lowerIt = lower instanceof Iterable ? (Set<Object>)lower : Collections.singleton(lower);
            Set<Object> upperIt = upper instanceof Iterable ? (Set<Object>)upper : Collections.singleton(upper);
            ArrayList<Segment.Range> answer = new ArrayList<Segment.Range>();
            for (Object t : lowerIt) {
                for (Object t2 : upperIt) {
                    answer.add(new Segment.Range(t, t2, includeLower, includeUpper));
                }
            }
            return answer;
        }

        public String name() {
            return ".f.range";
        }
    }

    private static class Fuzzy
    extends Base {
        private static final long serialVersionUID = 1L;

        private Fuzzy() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            Object obj = queue.constantValue((Type)Type.OBJECT).getOptional();
            Number number = (Number)queue.constantValue((Type)Type.NUMBER).get();
            ArrayList<Object> answer = new ArrayList<Object>();
            if (obj instanceof Iterable) {
                for (Object o : (Iterable)obj) {
                    answer.add(new Segment.Fuzzy(o, number.intValue()));
                }
            } else if (obj != null) {
                answer.add(new Segment.Fuzzy(obj, number.intValue()));
            } else {
                answer.add(new Segment.Star());
            }
            return answer;
        }

        public String name() {
            return ".f.fuzzy";
        }
    }

    private static class Literal
    extends Base {
        private static final long serialVersionUID = 1L;

        private Literal() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            Object obj = queue.get();
            if (obj instanceof Filter) {
                return obj;
            }
            if (obj instanceof IsFilter) {
                return ((IsFilter)obj).filter();
            }
            PipeException.check((boolean)ConstantHelper.isConstant((Object)obj), (String)"Expression '%s' must be constant to be used in a filter", (Object[])new Object[]{obj});
            obj = ConstantHelper.evaluate((Expression)((Expression)obj));
            ArrayList<Object> answer = new ArrayList<Object>();
            if (obj instanceof Iterable) {
                for (Object o : (Iterable)obj) {
                    answer.add(new Segment.Literal(o));
                }
            } else if (obj != null) {
                answer.add(new Segment.Literal(obj));
            } else {
                answer.add(new Segment.Star());
            }
            return answer;
        }

        public String name() {
            return ".f.literal";
        }
    }

    private static class Not
    extends Base {
        private static final long serialVersionUID = 1L;

        private Not() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            return new NotFilter((Filter)queue.get(Filter.class));
        }

        public String name() {
            return ".f.not";
        }
    }

    private static class Or
    extends Base {
        private static final long serialVersionUID = 1L;

        private Or() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            return new OrFilter((Filter[])queue.array(Filter.class));
        }

        public String name() {
            return ".f.or";
        }
    }

    private static class And
    extends Base {
        private static final long serialVersionUID = 1L;

        private And() {
        }

        public Object declare(ArgQueue queue) throws PipeException {
            return new AndFilter((Filter[])queue.array(Filter.class));
        }

        public String name() {
            return ".f.and";
        }
    }

    private static abstract class Base
    implements Function {
        private static final long serialVersionUID = 1L;

        private Base() {
        }

        public String description() {
            return this.name();
        }

        public HelpData help() {
            return null;
        }
    }
}

