/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.BuildingAutomata;
import net.intelie.pipes.filters.BuildingAutomaton;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterListener;
import net.intelie.pipes.filters.LocalListeners;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.Segment;
import net.intelie.pipes.filters.TermFilter;

public class FilterRegistrar {
    public void register(Filter filter, BuildingAutomata automata) {
        if (filter instanceof AndFilter) {
            this.registerAnd((AndFilter)filter, automata);
        } else if (filter instanceof OrFilter) {
            this.registerOr((OrFilter)filter, automata);
        } else if (filter instanceof NotFilter) {
            this.registerNot((NotFilter)filter, automata);
        } else if (filter instanceof TermFilter) {
            this.registerAutomaton((TermFilter)filter, automata);
        } else {
            throw new IllegalArgumentException("Unknown filter type " + filter);
        }
    }

    public void registerNot(NotFilter filter, BuildingAutomata automata) {
        this.register(filter.filter(), automata);
    }

    public void registerOr(OrFilter filter, BuildingAutomata automata) {
        for (Filter child : filter.filters()) {
            this.register(child, automata);
        }
    }

    public void registerAnd(AndFilter filter, BuildingAutomata automata) {
        for (Filter child : filter.filters()) {
            this.register(child, automata);
        }
    }

    public void registerAutomaton(TermFilter filter, BuildingAutomata automata) {
        BuildingAutomaton.Builder builder = automata.newAutomaton(filter.property().type());
        builder = this.registerSegments(filter.segments(), builder);
        automata.add(filter.property(), builder.build(0));
    }

    public BuildingAutomaton.Builder registerSegments(Iterable<Segment> segments, BuildingAutomaton.Builder builder) {
        for (Segment segment : segments) {
            builder = this.registerSegment(segment, builder);
        }
        return builder;
    }

    public BuildingAutomaton.Builder registerSegment(Segment segment, BuildingAutomaton.Builder builder) {
        if (segment instanceof Segment.Literal) {
            return this.registerLiteral(builder, (Segment.Literal)segment);
        }
        if (segment instanceof Segment.Fuzzy) {
            return this.registerFuzzy(builder, (Segment.Fuzzy)segment);
        }
        if (segment instanceof Segment.Range) {
            return this.registerRange(builder, (Segment.Range)segment);
        }
        if (segment instanceof Segment.Question) {
            return this.registerQuestion(builder, (Segment.Question)segment);
        }
        if (segment instanceof Segment.Star) {
            return this.registerStar(builder, (Segment.Star)segment);
        }
        throw new IllegalArgumentException("Unknown segment type " + segment);
    }

    public BuildingAutomaton.Builder registerStar(BuildingAutomaton.Builder builder, Segment.Star segment) {
        builder = builder.zeroOrMore();
        return builder;
    }

    public BuildingAutomaton.Builder registerQuestion(BuildingAutomaton.Builder builder, Segment.Question segment) {
        builder = builder.any();
        return builder;
    }

    public BuildingAutomaton.Builder registerRange(BuildingAutomaton.Builder builder, Segment.Range segment) {
        builder = builder.range(segment.lower(), segment.upper(), segment.includesLower(), segment.includesUpper());
        return builder;
    }

    public BuildingAutomaton.Builder registerFuzzy(BuildingAutomaton.Builder builder, Segment.Fuzzy segment) {
        builder = builder.fuzzy(segment.value(), segment.maxEdits());
        return builder;
    }

    public BuildingAutomaton.Builder registerLiteral(BuildingAutomaton.Builder builder, Segment.Literal segment) {
        builder = builder.literal(segment.value());
        return builder;
    }

    public void register(Filter filter, LocalListeners listeners, FilterListener listener) {
        if (filter instanceof AndFilter) {
            this.registerAnd((AndFilter)filter, listeners, listener);
        } else if (filter instanceof OrFilter) {
            this.registerOr((OrFilter)filter, listeners, listener);
        } else if (filter instanceof NotFilter) {
            this.registerNot((NotFilter)filter, listeners, listener);
        } else if (filter instanceof TermFilter) {
            this.registerAutomaton((TermFilter)filter, listeners, listener);
        } else {
            throw new IllegalArgumentException("Unknown filter type " + filter);
        }
    }

    public void registerAutomaton(TermFilter filter, LocalListeners listeners, FilterListener listener) {
        listeners.add(new TermListener(listener));
    }

    public void registerNot(NotFilter filter, LocalListeners listeners, FilterListener listener) {
        NotListener myListener = new NotListener(listener);
        this.register(filter.filter(), listeners, myListener);
        listeners.addDispose(new Negate(myListener));
    }

    public void registerOr(OrFilter filter, LocalListeners listeners, FilterListener listener) {
        OrListener myListener = new OrListener(listener);
        for (Filter child : filter.filters()) {
            this.register(child, listeners, myListener);
        }
    }

    public void registerAnd(AndFilter filter, LocalListeners listeners, FilterListener listener) {
        if (filter.isEmpty()) {
            listeners.addDispose(new AndListener(listener, 1));
        } else {
            AndListener myListener = new AndListener(listener, filter.filters().size());
            for (Filter child : filter.filters()) {
                this.register(child, listeners, myListener);
            }
        }
    }

    public class NotListener
    implements FilterListener {
        public final FilterListener listener;
        public long lastRun = 0L;

        public NotListener(FilterListener listener) {
            this.listener = listener;
        }

        @Override
        public void onMatch(long run, boolean value) {
            if (this.lastRun < run) {
                this.listener.onMatch(run, !value);
                this.lastRun = run;
            }
        }
    }

    public class Negate
    implements FilterListener {
        public final FilterListener listener;

        public Negate(FilterListener listener) {
            this.listener = listener;
        }

        @Override
        public void onMatch(long run, boolean value) {
            this.listener.onMatch(run, !value);
        }
    }

    public static class OrListener
    implements FilterListener {
        public final FilterListener listener;
        public long lastRun;

        public OrListener(FilterListener listener) {
            this.listener = listener;
            this.lastRun = 0L;
        }

        @Override
        public void onMatch(long run, boolean value) {
            if (this.lastRun < run && value) {
                this.listener.onMatch(run, true);
                this.lastRun = run;
            }
        }
    }

    public static class AndListener
    implements FilterListener {
        public final FilterListener listener;
        public final int expected;
        public int count;
        public long countRun;

        public AndListener(FilterListener listener, int expected) {
            this.listener = listener;
            this.expected = expected;
            this.countRun = 0L;
            this.count = 0;
        }

        @Override
        public void onMatch(long run, boolean value) {
            if (this.countRun < run) {
                this.count = 0;
                this.countRun = run;
            }
            if (value && ++this.count == this.expected) {
                this.listener.onMatch(run, true);
            }
        }
    }

    public static class TermListener
    implements FilterListener {
        public final FilterListener listener;
        public long lastRun;

        public TermListener(FilterListener listener) {
            this.listener = listener;
            this.lastRun = 0L;
        }

        @Override
        public void onMatch(long run, boolean value) {
            if (run > this.lastRun) {
                this.lastRun = run;
                this.listener.onMatch(this.lastRun, value);
            }
        }
    }
}

