/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.List;
import java.util.UUID;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.TermFilter;
import net.intelie.pipes.util.AutomatonRepr;

public class FilterReprBuilder {
    public int build(Filter filter, AutomatonRepr repr, int id) {
        if (filter instanceof AndFilter) {
            return this.buildAnd((AndFilter)filter, repr, id);
        }
        if (filter instanceof OrFilter) {
            return this.buildOr((OrFilter)filter, repr, id);
        }
        if (filter instanceof NotFilter) {
            return this.buildNot((NotFilter)filter, repr, id);
        }
        if (filter instanceof TermFilter) {
            return this.buildAutomaton((TermFilter)filter, repr, id);
        }
        throw new IllegalArgumentException("Unknown filter type " + filter);
    }

    private int buildAutomaton(TermFilter filter, AutomatonRepr repr, int id) {
        repr.addReserved("listener_" + id);
        repr.setStartId("listener_" + id);
        return id + 1;
    }

    private int buildNot(NotFilter filter, AutomatonRepr repr, int id) {
        String nodeId = "n" + UUID.randomUUID().toString().replace("-", "");
        id = this.build(filter.filter(), repr, id);
        repr.addEdge(repr.getStartId(), nodeId, (Object)"");
        repr.addNode("diamond", nodeId, (Object)"not");
        repr.setStartId(nodeId);
        return id;
    }

    private int buildOr(OrFilter filter, AutomatonRepr repr, int id) {
        return this.buildMany(filter.filters(), repr, id, "or");
    }

    private int buildAnd(AndFilter filter, AutomatonRepr repr, int id) {
        return this.buildMany(filter.filters(), repr, id, "and");
    }

    private int buildMany(List<Filter> children, AutomatonRepr repr, int id, String name) {
        String nodeId = "n" + UUID.randomUUID().toString().replace("-", "");
        for (Filter child : children) {
            id = this.build(child, repr, id);
            repr.addEdge(repr.getStartId(), nodeId, (Object)"");
        }
        repr.addNode("diamond", nodeId, (Object)name);
        repr.setStartId(nodeId);
        return id;
    }
}

