/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.intelie.pipes.FilterAction;
import net.intelie.pipes.filters.BuildingAutomata;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterListener;
import net.intelie.pipes.filters.FilterRegistrar;
import net.intelie.pipes.filters.FilterReprBuilder;
import net.intelie.pipes.filters.FinalAutomata;
import net.intelie.pipes.filters.LocalListenersImpl;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.util.AutomatonRepr;
import net.intelie.pipes.util.ObjectPool;

public class FilterRuntime<T> {
    private final ObjectPool<LocalAutomata> pool;
    private final LocalAutomata single;
    private final Map<Object, FilterPair> pairs;
    private final FilterRegistrar registrar;
    private final FilterReprBuilder reprBuilder;
    private final boolean autoFlush;
    private volatile long masterVersion;
    private volatile GlobalAutomata automata;

    public FilterRuntime() {
        this(true);
    }

    public FilterRuntime(boolean autoFlush) {
        this.autoFlush = autoFlush;
        this.pairs = new HashMap<Object, FilterPair>();
        this.registrar = new FilterRegistrar();
        this.reprBuilder = new FilterReprBuilder();
        this.masterVersion = 0L;
        this.automata = new GlobalAutomata(0L);
        this.single = new LocalAutomata();
        this.pool = new ObjectPool(() -> new LocalAutomata());
    }

    public synchronized long register(Object id, Filter filter, T sink) {
        this.pairs.put(id, new FilterPair(id, filter, sink));
        return this.maybeAutoFlush();
    }

    public synchronized long unregister(Object ... ids) {
        for (Object id : ids) {
            this.pairs.remove(id);
        }
        return this.maybeAutoFlush();
    }

    public synchronized long clear() {
        this.pairs.clear();
        return this.maybeAutoFlush();
    }

    private long maybeAutoFlush() {
        return this.autoFlush ? this.flush() : this.masterVersion;
    }

    public synchronized long flush() {
        return ++this.masterVersion;
    }

    public synchronized int size() {
        return this.pairs.size();
    }

    public int flow(Object obj, FilterAction<T> action) {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            int n = ((LocalAutomata)ref.obj()).flow(obj, action);
            return n;
        }
    }

    public int flowMany(Iterable obj, FilterAction<T> action) {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            int n = ((LocalAutomata)ref.obj()).flowMany(obj, action);
            return n;
        }
    }

    public int flowSingle(Object obj, FilterAction<T> action) {
        return this.single.flow(obj, action);
    }

    public void forceUpdate() {
        this.internalGlobalUpdate();
    }

    public AutomatonRepr repr(boolean simplify) {
        GlobalAutomata saved = this.automata;
        AutomatonRepr repr = saved.automata.repr(simplify);
        AutomatonRepr temp = new AutomatonRepr("");
        int id = 0;
        for (int i = 0; i < saved.pairs.size(); ++i) {
            FilterPair pair = (FilterPair)saved.pairs.get(i);
            id = this.reprBuilder.build(pair.filter, temp, id);
            temp.addNode("rectangle", "filter_" + i, pair.id);
            temp.addEdge(temp.getStartId(), "filter_" + i, (Object)"");
        }
        repr.merge("f_", temp);
        return repr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalAutomata internalGlobalUpdate() {
        GlobalAutomata savedAutomata = this.automata;
        if (savedAutomata.version != this.masterVersion) {
            FilterRuntime filterRuntime = this;
            synchronized (filterRuntime) {
                if (this.automata.version != this.masterVersion) {
                    this.automata = new GlobalAutomata(this.masterVersion);
                }
                savedAutomata = this.automata;
            }
        }
        return savedAutomata;
    }

    private class ThreadLocalListener
    implements FilterListener {
        private final FilterPair pair;
        private final LocalAutomata local;
        private final List<Object> list;

        public ThreadLocalListener(FilterPair pair, LocalAutomata local) {
            this.pair = pair;
            this.local = local;
            this.list = new ArrayList<Object>();
        }

        @Override
        public void onMatch(long run, boolean value) {
            if (value) {
                if (this.local.single) {
                    try {
                        this.local.lastAction.onSingle(this.local.last, this.pair.sink);
                    }
                    catch (Throwable e) {
                        Logger.getLogger(ThreadLocalListener.class.getName()).log(Level.WARNING, "Uncaught exception", e);
                    }
                    this.local.matchedInt++;
                } else {
                    this.list.add(this.local.last);
                    this.local.matched.add(this);
                }
            }
        }

        public void flush() {
            try {
                if (this.list.size() == this.local.count) {
                    this.local.lastAction.onBatch(this.local.lastList, this.pair.sink);
                } else {
                    this.local.lastAction.onBatch(new ArrayList<Object>(this.list), this.pair.sink);
                }
            }
            catch (Throwable e) {
                Logger.getLogger(ThreadLocalListener.class.getName()).log(Level.WARNING, "Uncaught exception", e);
            }
            finally {
                this.list.clear();
            }
        }
    }

    private class FilterPair {
        private final Object id;
        private final Filter filter;
        private final T sink;

        public FilterPair(Object id, Filter filter, T sink) {
            this.id = id;
            this.filter = filter;
            this.sink = sink;
        }

        public void register(BuildingAutomata automata) {
            FilterRuntime.this.registrar.register(this.filter, automata);
        }

        public void register(LocalAutomata local, LocalListenersImpl listeners) {
            FilterRuntime.this.registrar.register(this.filter, listeners, new ThreadLocalListener(this, local));
        }
    }

    private class LocalAutomata {
        private final Set<ThreadLocalListener> matched = new HashSet<ThreadLocalListener>();
        private Object last = null;
        private FilterAction<T> lastAction = null;
        private boolean single;
        private volatile int count = 0;
        private volatile int matchedInt = 0;
        private volatile long version = 0L;
        private volatile FinalAutomata.Instance instance = null;
        private volatile Iterable lastList;

        private LocalAutomata() {
        }

        public int flow(Object obj, FilterAction<T> action) {
            this.single = true;
            this.before(action);
            this.last = obj;
            this.instance.flow(this.last);
            this.last = null;
            this.lastAction = null;
            return this.matchedInt;
        }

        public int flowMany(Iterable list, FilterAction<T> action) {
            this.single = false;
            this.before(action);
            this.lastList = list;
            if (list != null) {
                for (Object obj : list) {
                    ++this.count;
                    this.last = obj;
                    this.instance.flow(this.last);
                    this.last = null;
                }
            }
            for (ThreadLocalListener listener : this.matched) {
                listener.flush();
            }
            this.lastList = null;
            this.lastAction = null;
            return this.matched.size();
        }

        private void before(FilterAction<T> action) {
            this.maybeSync();
            this.matched.clear();
            this.matchedInt = 0;
            this.count = 0;
            this.lastAction = action;
        }

        private GlobalAutomata maybeSync() {
            GlobalAutomata savedAutomata = FilterRuntime.this.internalGlobalUpdate();
            if (savedAutomata.version != this.version || this.instance == null) {
                LocalListenersImpl listeners = new LocalListenersImpl();
                for (FilterPair pair : savedAutomata.pairs) {
                    pair.register(this, listeners);
                }
                this.version = savedAutomata.version;
                this.instance = savedAutomata.automata.newInstance(listeners);
            }
            return savedAutomata;
        }
    }

    private class GlobalAutomata {
        private final FinalAutomata automata;
        private final long version;
        private final List<FilterPair> pairs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GlobalAutomata(long version) {
            ArrayList copied;
            FilterRuntime filterRuntime2 = FilterRuntime.this;
            synchronized (filterRuntime2) {
                copied = new ArrayList(FilterRuntime.this.pairs.values());
            }
            this.version = version;
            this.pairs = copied;
            this.automata = this.makeFrozen();
        }

        private FinalAutomata makeFrozen() {
            BuildingAutomata temp = new BuildingAutomata();
            for (FilterPair pair : this.pairs) {
                pair.register(temp);
            }
            return temp.freeze();
        }
    }

    public static class Default
    extends FilterRuntime<ObjectSink> {
        public Default() {
        }

        public Default(boolean autoFlush) {
            super(autoFlush);
        }

        public int flow(Object obj) {
            return this.flow(obj, FilterAction.DEFAULT);
        }

        public int flowMany(Iterable it) {
            return this.flowMany(it, FilterAction.DEFAULT);
        }

        public int flowSingle(Object obj) {
            return this.flowSingle(obj, FilterAction.DEFAULT);
        }
    }
}

