/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.Arrays;
import java.util.Locale;
import net.intelie.pipes.filters.AutomatonListener;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.AutomatonRepr;

public class FinalAutomaton {
    public static final long CONSUMES = Long.MIN_VALUE;
    public static final long NEXT = 0x7FFFFFFF00000000L;
    public static final long HI = 0xFFFF0000L;
    public static final long LO = 65535L;
    private final int[] produces;
    private final long[] next;
    private final int[] nStart;
    private final int[] nSize;
    private final int[] pStart;
    private final int[] pSize;
    private final Type type;

    public FinalAutomaton(Type type, int[] produces, long[] next, int[] nStart, int[] nSize, int[] pStart, int[] pSize) {
        this.type = type;
        this.produces = produces;
        this.next = next;
        this.nStart = nStart;
        this.nSize = nSize;
        this.pStart = pStart;
        this.pSize = pSize;
    }

    private static int nextState(long value) {
        return (int)((value & 0x7FFFFFFF00000000L) >>> 32);
    }

    private static boolean accepts(long value, int c) {
        return FinalAutomaton.consumes(value) & (value & 0xFFFFL) <= (long)c & (long)c <= (value & 0xFFFF0000L) >>> 16;
    }

    private static boolean consumes(long value) {
        return (value & Long.MIN_VALUE) != 0L;
    }

    public AutomatonRepr repr(boolean simplify) {
        AutomatonRepr repr = new AutomatonRepr("s0");
        int[] incidence = new int[this.pStart.length];
        for (long lvalue : this.next) {
            int n = FinalAutomaton.nextState(lvalue);
            incidence[n] = incidence[n] + 1;
        }
        boolean[] visited = new boolean[this.nStart.length];
        for (int i = 0; i < this.nStart.length; ++i) {
            this.visitNode(repr, i, simplify, visited, incidence);
        }
        return repr;
    }

    private void visitNode(AutomatonRepr repr, int i, boolean simplify, boolean[] visited, int[] incidence) {
        int j;
        if (visited[i]) {
            return;
        }
        if (this.pSize[i] > 0) {
            repr.addNode("doublecircle", "s" + i, simplify ? "" : Integer.valueOf(i));
            for (j = this.pStart[i]; j < this.pStart[i] + this.pSize[i]; ++j) {
                if (simplify) {
                    repr.addAlias("listener_" + this.produces[j], "s" + i);
                    continue;
                }
                repr.addNode("diamond", "listener_" + this.produces[j], (Object)this.produces[j]);
                repr.addEdge("s" + i, "listener_" + this.produces[j], (Object)"");
                repr.addReserved("listener_" + this.produces[j]);
            }
        } else {
            repr.addNode("circle", "s" + i, simplify ? "" : Integer.valueOf(i));
        }
        for (j = this.nStart[i]; j < this.nStart[i] + this.nSize[i]; ++j) {
            long lvalue;
            int state = (int)((this.next[j] & 0x7FFFFFFF00000000L) >>> 32);
            StringBuilder trans = new StringBuilder(this.makeLabel(this.next[j]));
            if (this.sameLoHi(this.next[j])) {
                while (simplify && this.nSize[state] == 1 && incidence[state] == 1 && this.pSize[state] == 0 && this.sameLoHi(this.next[this.nStart[state]])) {
                    visited[state] = true;
                    lvalue = this.next[this.nStart[state]];
                    state = (int)((lvalue & 0x7FFFFFFF00000000L) >>> 32);
                    trans.append(this.makeLabel(lvalue));
                }
            } else {
                while (simplify && this.nSize[state] == 1 && incidence[state] == 1 && this.pSize[state] == 0 && !FinalAutomaton.consumes(this.next[this.nStart[state]])) {
                    visited[state] = true;
                    lvalue = this.next[this.nStart[state]];
                    state = (int)((lvalue & 0x7FFFFFFF00000000L) >>> 32);
                    trans.append(this.makeLabel(lvalue));
                }
            }
            repr.addEdge("s" + i, "s" + state, (Object)trans.toString());
        }
    }

    private boolean sameLoHi(long lvalue) {
        long lo = lvalue & 0xFFFFL;
        long hi = (lvalue & 0xFFFF0000L) >>> 16;
        return lo == hi;
    }

    private String makeLabel(long lvalue) {
        if (FinalAutomaton.consumes(lvalue)) {
            long hi = (lvalue & 0xFFFF0000L) >>> 16;
            long lo = lvalue & 0xFFFFL;
            if (hi == lo) {
                return this.makeValue(lo);
            }
            if (hi == 65535L && lo == 0L) {
                return "?";
            }
            return "[" + (lo == 0L ? "*" : this.makeValue(lo)) + "-" + (hi == 65535L ? "*" : this.makeValue(hi)) + "]";
        }
        return "";
    }

    private String makeValue(long lo) {
        char c = (char)lo;
        if (Type.STRING.equals((Object)this.type)) {
            return String.format((Locale)null, "%c", Character.valueOf(c));
        }
        return String.format((Locale)null, "%04x", (int)c);
    }

    public Instance newInstance() {
        return new Instance();
    }

    static /* synthetic */ Type access$200(FinalAutomaton x0) {
        return x0.type;
    }

    public final class Instance {
        private final Arr arr1 = new Arr();
        private final Arr arr2 = new Arr();
        private final int[] list = new int[FinalAutomaton.access$100(FinalAutomaton.this).length];
        private final BinaryIterator iterator = FinalAutomaton.access$200(FinalAutomaton.this).newIterator();
        private int run = Integer.MAX_VALUE;

        public void offer(Object input, AutomatonListener listener) {
            if (this.iterator.reset(input)) {
                this.process(this.iterator, listener);
            }
            this.iterator.clear();
        }

        private void nextRun() {
            if (++this.run == Integer.MIN_VALUE) {
                ++this.run;
                Arrays.fill(this.list, Integer.MIN_VALUE);
            }
        }

        private void process(BinaryIterator input, AutomatonListener listener) {
            Arr P = this.arr1;
            Arr Q = this.arr2;
            P.n = (Q.n = 0);
            this.nextRun();
            this.addState(P, 0, input.isLast(), listener);
            while (input.moveNext()) {
                this.nextRun();
                int c = input.current();
                boolean last = input.isLast();
                for (int j = 0; j < P.n; ++j) {
                    int k;
                    int state = P.V[j];
                    int kk = k + FinalAutomaton.this.nSize[state];
                    for (k = FinalAutomaton.this.nStart[state]; k < kk; ++k) {
                        if (!FinalAutomaton.accepts(FinalAutomaton.this.next[k], c)) continue;
                        this.addState(Q, FinalAutomaton.nextState(FinalAutomaton.this.next[k]), last, listener);
                    }
                }
                Arr T = Q;
                Q = P;
                P = T;
                Q.n = 0;
            }
        }

        private void addState(Arr arr, int state, boolean last, AutomatonListener listener) {
            int j;
            if (this.list[state] == this.run) {
                return;
            }
            this.list[state] = this.run;
            if (last) {
                int j2;
                int jj = j2 + FinalAutomaton.this.pSize[state];
                for (j2 = FinalAutomaton.this.pStart[state]; j2 < jj; ++j2) {
                    listener.onMatch(FinalAutomaton.this.produces[j2]);
                }
            }
            boolean consumes = false;
            int jj = j + FinalAutomaton.this.nSize[state];
            for (j = FinalAutomaton.this.nStart[state]; j < jj; ++j) {
                if (!FinalAutomaton.consumes(FinalAutomaton.this.next[j])) {
                    this.addState(arr, FinalAutomaton.nextState(FinalAutomaton.this.next[j]), last, listener);
                    continue;
                }
                consumes = true;
            }
            if (consumes) {
                if (arr.n == arr.V.length) {
                    Arr.access$402(arr, Arrays.copyOf(arr.V, arr.V.length * 2));
                }
                ((Arr)arr).V[((Arr)arr).n++] = state;
            }
        }

        private class Arr {
            private int[] V = new int[1];
            private int n = 0;

            private Arr() {
            }

            static /* synthetic */ int[] access$402(Arr x0, int[] x1) {
                x0.V = x1;
                return x1;
            }
        }
    }
}

