/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import net.intelie.pipes.filters.AutomatonListener;
import net.intelie.pipes.filters.BuildingAutomaton;
import net.intelie.pipes.filters.FilterRegistrar;
import net.intelie.pipes.filters.FinalAutomaton;
import net.intelie.pipes.filters.Segment;
import net.intelie.pipes.types.Type;

public class SegmentsTester {
    private final FinalAutomaton.Instance automaton;
    private final MyAutomatonListener listener;

    public SegmentsTester(Iterable<Segment> segments) {
        this(segments, (Type)Type.STRING);
    }

    public SegmentsTester(Iterable<Segment> segments, Type type) {
        FilterRegistrar registrar = new FilterRegistrar();
        BuildingAutomaton.Builder builder = new BuildingAutomaton.Builder(type);
        registrar.registerSegments(segments, builder);
        this.automaton = builder.build(0).freeze().newInstance();
        this.listener = new MyAutomatonListener();
    }

    public boolean accepts(Object value) {
        this.listener.value = false;
        this.automaton.offer(value, this.listener);
        return this.listener.value;
    }

    private static class MyAutomatonListener
    implements AutomatonListener {
        private boolean value = false;

        private MyAutomatonListener() {
        }

        @Override
        public void onMatch(int id) {
            this.value = true;
        }
    }
}

